/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class GaussianSmooth
extends Thread {
    public static double gaussianDiscrete2D(double d, int n, int n2) {
        double d2 = 0.0;
        for (double d3 = (double)n2 - 0.5; d3 < (double)n2 + 0.55; d3 += 0.1) {
            for (double d4 = (double)n - 0.5; d4 < (double)n + 0.55; d4 += 0.1) {
                d2 += 1.0 / (Math.PI * 2 * d * d) * Math.pow(Math.E, -(d4 * d4 + d3 * d3) / (2.0 * d * d));
            }
        }
        return d2 /= 121.0;
    }

    public static double[][] gaussian2D(double d, int n) {
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[j][i] = GaussianSmooth.gaussianDiscrete2D(d, j - n / 2, i - n / 2);
            }
        }
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                d2 += dArray[j][i];
            }
        }
        return dArray;
    }

    public static double[][] smooth(double[][] dArray, int n, int n2, int n3, double d) {
        Convolution convolution = new Convolution();
        double[][] dArray2 = new double[n3][n3];
        double[][] dArray3 = new double[n][n2];
        dArray2 = GaussianSmooth.gaussian2D(d, n3);
        dArray3 = Convolution.convolution2DPadded(dArray, n, n2, dArray2, n3, n3);
        return dArray3;
    }

    public static int[] smooth_image(int[] nArray, int n, int n2, int n3, double d) {
        int n4;
        int n5;
        double[][] dArray = new double[n][n2];
        double[] dArray2 = new double[n * n2];
        double[][] dArray3 = new double[n][n2];
        int[] nArray2 = new int[n * n2];
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                dArray[n4][n5] = new Color(nArray[n5 * n + n4]).getRed();
            }
        }
        dArray3 = GaussianSmooth.smooth(dArray, n, n2, n3, d);
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                dArray2[n5 * n + n4] = dArray3[n4][n5];
            }
        }
        for (n5 = 0; n5 < dArray2.length; ++n5) {
            n4 = (int)Math.round(dArray2[n5]);
            if (n4 > 255) {
                n4 = 255;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            nArray2[n5] = new Color(n4, n4, n4).getRGB();
        }
        return nArray2;
    }
}

