/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Point;
import java.util.HashSet;
import java.util.Iterator;

public class BinaryFast
extends image {
    public static final int background = new Color(0, 0, 0).getRGB();
    public static final int foreground = new Color(255, 255, 255).getRGB();
    public int w;
    public int h;
    public int s;
    public int[][] pixels;
    public HashSet foregroundEdgePixels = new HashSet();
    public HashSet backgroundEdgePixels = new HashSet();

    public BinaryFast(image image2) {
        this.w = image2.getWidth();
        this.h = image2.getHeight();
        this.s = this.w * this.h;
        this.pixels = new int[this.w][this.h];
        if (image2 != null) {
            if (image2 instanceof image1DInt) {
                int n;
                int n2;
                int[][] nArray = new int[this.w][this.h];
                int[] nArray2 = new int[this.s];
                nArray2 = (int[])image2.getValues().clone();
                for (n2 = 0; n2 < this.w; ++n2) {
                    for (n = 0; n < this.h; ++n) {
                        nArray[n2][n] = nArray2[n * this.w + n2];
                    }
                }
                this.pixels = nArray;
                for (n2 = 0; n2 < this.w; ++n2) {
                    for (n = 0; n < this.h; ++n) {
                        int n3 = this.pixels[n2][n];
                        if (n3 >= 128) {
                            n3 = 255;
                            this.pixels[n2][n] = -1;
                            continue;
                        }
                        n3 = 0;
                        this.pixels[n2][n] = -16777216;
                    }
                }
            } else if (image2 instanceof image2DDouble) {
                int[] nArray = new int[this.s];
                nArray = image2.getValues();
                for (int i = 0; i < this.w; ++i) {
                    for (int j = 0; j < this.h; ++j) {
                        int n = nArray[j * this.w + i];
                        n = n >= 128 ? 255 : 0;
                        this.pixels[i][j] = new Color(n, n, n).getRGB();
                    }
                }
            } else if (image2 instanceof image2DInt) {
                int[] nArray = new int[this.s];
                nArray = image2.getValues();
                for (int i = 0; i < this.w; ++i) {
                    for (int j = 0; j < this.h; ++j) {
                        int n = nArray[j * this.w + i];
                        n = n >= 128 ? 255 : 0;
                        this.pixels[i][j] = new Color(n, n, n).getRGB();
                    }
                }
            }
        }
        this.generateForegroundEdge();
        this.generateBackgroundEdgeFromForegroundEdge();
    }

    public BinaryFast(int[][] nArray, int n, int n2) {
        this.pixels = nArray;
        this.w = n;
        this.h = n2;
        this.s = this.w * this.h;
        this.generateForegroundEdge();
        this.generateBackgroundEdgeFromForegroundEdge();
    }

    public BinaryFast() {
        this.foregroundEdgePixels = new HashSet();
        this.backgroundEdgePixels = new HashSet();
    }

    public BinaryFast(BinaryFast binaryFast) {
        this.w = binaryFast.w;
        this.h = binaryFast.h;
        this.s = binaryFast.s;
        this.backgroundEdgePixels = new HashSet();
        Iterator iterator = binaryFast.backgroundEdgePixels.iterator();
        while (iterator.hasNext()) {
            this.backgroundEdgePixels.add(iterator.next());
        }
        this.foregroundEdgePixels = new HashSet();
        Iterator iterator2 = binaryFast.foregroundEdgePixels.iterator();
        while (iterator2.hasNext()) {
            this.foregroundEdgePixels.add(iterator2.next());
        }
        this.pixels = (int[][])binaryFast.pixels.clone();
    }

    public void removePixel(Point point) {
        this.pixels[point.x][point.y] = background;
    }

    public void addPixel(Point point) {
        this.pixels[point.x][point.y] = foreground;
    }

    public int[] convertToArray() {
        int[] nArray = new int[this.s];
        for (int i = 0; i < this.h; ++i) {
            for (int j = 0; j < this.w; ++j) {
                nArray[i * this.w + j] = this.pixels[j][i];
            }
        }
        return nArray;
    }

    public void generatePixels(HashSet hashSet) {
        for (int i = 0; i < this.h; ++i) {
            for (int j = 0; j < this.w; ++j) {
                this.pixels[j][i] = background;
            }
        }
        this.convertToPixels(hashSet);
    }

    public void convertToPixels(HashSet hashSet) {
        boolean bl = false;
        Point point = new Point();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            point = (Point)iterator.next();
            this.pixels[point.x][point.y] = foreground;
        }
    }

    public void generateForegroundEdge() {
        this.foregroundEdgePixels.clear();
        for (int i = 0; i < this.h; ++i) {
            for (int j = 0; j < this.w; ++j) {
                if (this.pixels[j][i] != foreground) continue;
                Point point = new Point(j, i);
                for (int k = -1; k < 2; ++k) {
                    for (int i2 = -1; i2 < 2; ++i2) {
                        if (point.x + i2 < 0 || point.x + i2 >= this.w || point.y + k < 0 || point.y + k >= this.h || this.pixels[point.x + i2][point.y + k] != background || this.foregroundEdgePixels.contains(point)) continue;
                        this.foregroundEdgePixels.add(point);
                    }
                }
            }
        }
    }

    public void generateBackgroundEdgeFromForegroundEdge() {
        this.backgroundEdgePixels.clear();
        Iterator iterator = this.foregroundEdgePixels.iterator();
        while (iterator.hasNext()) {
            Point point = new Point((Point)iterator.next());
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    if (point.x + j < 0 || point.x + j >= this.w || point.y + i < 0 || point.y + i >= this.h) continue;
                    Point point2 = new Point(point.x + j, point.y + i);
                    if (this.pixels[point2.x][point2.y] != background) continue;
                    this.backgroundEdgePixels.add(point2);
                }
            }
        }
    }

    public void generateForegroundEdgeFromBackgroundEdge() {
        this.foregroundEdgePixels.clear();
        Iterator iterator = this.backgroundEdgePixels.iterator();
        while (iterator.hasNext()) {
            Point point = new Point((Point)iterator.next());
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    if (point.x + j < 0 || point.x + j >= this.w || point.y + i < 0 || point.y + i >= this.h) continue;
                    Point point2 = new Point(point.x + j, point.y + i);
                    if (this.pixels[point2.x][point2.y] != foreground) continue;
                    this.foregroundEdgePixels.add(point2);
                }
            }
        }
    }

    public int[] getValues() {
        int[] nArray = new int[this.s];
        int[] nArray2 = new int[this.s];
        nArray = this.convertToArray();
        for (int i = 0; i < this.s; ++i) {
            nArray2[i] = nArray[i] & 0xFF;
        }
        return nArray2;
    }
}

