/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class FFTInterface
extends SingleInputImageInterface {
    DefinableNotchInterface coordNotch;
    NotchFilterInterface notch;
    FreqFilterInterface freq;
    GaussianInterface gaussian;
    TimeTakenInterface timetaken;
    private long time1;
    private long time2;
    FFT fft = new FFT();
    InverseFFT inverse = new InverseFFT();
    public JPanel leftPanel;
    public Image fourierImageCurrent;
    public JLabel[] fourierLabel = new JLabel[7];
    public JLabel fourierCurrentLabel = new JLabel();
    public ImageIcon[] fourierIcon = new ImageIcon[7];
    public ImageIcon fourierCurrentIcon;
    double[] fourierCurrent;
    public JTabbedPane fourierPane;
    public JPanel fourierPanel;
    public JLabel fourierCurrentDims = new JLabel();

    public void updateFourierImages() {
        int n = this.fft.output.width;
        int n2 = this.fft.output.height;
        double[][] dArray = new double[7][n * n2];
        int[] nArray = new int[n * n2];
        dArray[0] = this.fft.intermediate.DCToCentre(this.fft.intermediate.getMagnitude());
        dArray[1] = ImageMods.logs(dArray[0]);
        dArray[2] = ImageMods.abs(this.fft.intermediate.DCToCentre(this.fft.intermediate.getPhase()));
        dArray[3] = ImageMods.abs(this.fft.intermediate.DCToCentre(this.fft.intermediate.getReal()));
        dArray[4] = ImageMods.logs(dArray[3]);
        dArray[5] = ImageMods.abs(this.fft.intermediate.DCToCentre(this.fft.intermediate.getImaginary()));
        dArray[6] = ImageMods.logs(dArray[5]);
        for (int i = 0; i < 7; ++i) {
            nArray = ImageMods.toPixels(dArray[i]);
            this.fourierLabel[i] = new JLabel();
            this.fourierLabel[i].setIcon(this.imageTools.scaleImage(new ImageIcon(this.createImage(new MemoryImageSource(n, n2, nArray, 0, n)))));
        }
        this.updateTabs();
    }

    public int[][] convertTo2D(int[] nArray, int n, int n2) {
        int[][] nArray2 = new int[n][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray2[j][i] = nArray[i * n + j];
            }
        }
        return nArray2;
    }

    void initialiseFourier() {
        System.out.println("Doing the FFT now");
        this.fft = new FFT(this.inputArray, this.inputWidth, this.inputHeight);
        this.updateFourierImages();
    }

    void updateTabs() {
        int n = this.fourierPane.getSelectedIndex();
        this.fourierPane.removeAll();
        String[] stringArray = new String[]{"Magnitude", "Magnitude Log", "Phase Angle", "Real", "Real Log", "Imaginary", "Imaginary Log"};
        for (int i = 0; i < 7; ++i) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(null);
            verticalAxis verticalAxis2 = new verticalAxis(this.inputHeight);
            horizontalAxis horizontalAxis2 = new horizontalAxis(this.inputWidth);
            jPanel.add(verticalAxis2);
            jPanel.add(horizontalAxis2);
            jPanel.add(this.fourierLabel[i]);
            verticalAxis2.setBounds(0, 0, 40, 260);
            horizontalAxis2.setBounds(0, 256, 350, 40);
            this.fourierLabel[i].setBounds(40, 0, 256, 256);
            this.fourierPane.addTab(stringArray[i], null, jPanel, stringArray[i]);
        }
        this.fourierPane.setSelectedIndex(n);
    }

    public void loadImage() {
        if (this.initialiseImages()) {
            this.initialiseFourier();
            this.updateTabs();
        }
    }

    public JPanel createStartPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 0)), "Apply"));
        jPanel.setOpaque(false);
        this.timetaken = new TimeTakenInterface();
        JPanel jPanel2 = this.timetaken.createPanel();
        JButton jButton = new JButton("Fourier Transform");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTInterface.this.time1 = System.currentTimeMillis();
                FFTInterface.this.initialiseFourier();
                FFTInterface.this.time2 = System.currentTimeMillis();
                FFTInterface.this.timetaken.updateTime(FFTInterface.this.time1, FFTInterface.this.time2);
            }
        });
        JButton jButton2 = new JButton("Inverse Fourier Transform");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTInterface.this.time1 = System.currentTimeMillis();
                if (FFTInterface.this.fourierPane.getTabCount() == 1) {
                    JOptionPane.showMessageDialog(null, "Must Apply Fourier Transform First", "No Fourier Transform Result", 2);
                } else {
                    FFTInterface.this.fft.output = FFTInterface.this.inverse.transform(FFTInterface.this.fft.intermediate);
                    double[] dArray = new double[FFTInterface.this.fft.output.width * FFTInterface.this.fft.output.height];
                    dArray = FFTInterface.this.fft.output.getReal();
                    FFTInterface.this.outputArray = new int[dArray.length];
                    FFTInterface.this.outputArray = ImageMods.toPixels(ImageMods.allPositive(dArray));
                    boolean bl = false;
                    int n = 255;
                    FFTInterface.this.updateOutput(FFTInterface.this.createImage(new MemoryImageSource(FFTInterface.this.fft.output.width, FFTInterface.this.fft.output.height, FFTInterface.this.outputArray, 0, FFTInterface.this.fft.output.width)), FFTInterface.this.fft.output.width, FFTInterface.this.fft.output.height);
                    FFTInterface.this.time2 = System.currentTimeMillis();
                    FFTInterface.this.timetaken.updateTime(FFTInterface.this.time1, FFTInterface.this.time2);
                }
            }
        });
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        jPanel.add(jButton2);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void createFourierPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setBackground(Color.white);
        verticalAxis verticalAxis2 = new verticalAxis(256);
        horizontalAxis horizontalAxis2 = new horizontalAxis(256);
        jPanel.add(verticalAxis2);
        jPanel.add(horizontalAxis2);
        verticalAxis2.setBounds(0, 0, 40, 260);
        horizontalAxis2.setBounds(0, 256, 350, 40);
        this.fourierPane = new JTabbedPane(2);
        this.fourierPane.setPreferredSize(new Dimension(435, 350));
        this.fourierPane.setAlignmentY(1.0f);
        this.fourierPane.addTab("Fourier Images", null, jPanel, "Fourier not applied");
        this.fourierPanel = new JPanel();
        this.fourierPanel.setLayout(new BoxLayout(this.fourierPanel, 1));
        this.fourierPanel.add(this.fourierPane);
        JButton jButton = new JButton("Reset Images");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FFTInterface.this.fourierPane.getTabCount() == 1) {
                    JOptionPane.showMessageDialog(null, "Must Apply Fourier Transform First", "No Fourier Transform Result", 2);
                } else {
                    FFTInterface.this.fft.intermediate = new TwoDArray(FFTInterface.this.fft.input);
                    FFTInterface.this.updateFourierImages();
                    FFTInterface.this.updateTabs();
                }
            }
        });
        this.fourierPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.fourierPanel.add(jButton);
        this.fourierPanel.add(Box.createRigidArea(new Dimension(0, 200)));
    }

    public void setLook() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setContainer() {
        this.container = this.getContentPane();
        this.container.setLayout(new BorderLayout());
        this.container.setBackground(Color.white);
        this.notch = new NotchFilterInterface();
        this.freq = new FreqFilterInterface();
        this.coordNotch = new DefinableNotchInterface();
        this.gaussian = new GaussianInterface();
        JPanel jPanel = this.coordNotch.createPanel();
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = this.notch.createPanel();
        jPanel2.setAlignmentX(0.0f);
        JPanel jPanel3 = this.freq.createPanel();
        jPanel3.setAlignmentX(0.0f);
        JPanel jPanel4 = this.gaussian.createPanel();
        jPanel4.setAlignmentX(0.0f);
        JPanel jPanel5 = this.createStartPanel();
        this.loadPanel = this.createLoadPanel();
        this.imagesPanel = this.createImagesPanel();
        this.imagesPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.leftPanel = new JPanel();
        JPanel jPanel6 = new JPanel();
        this.leftPanel.setLayout(new BorderLayout());
        this.leftPanel.setAlignmentY(1.0f);
        this.leftPanel.setBackground(Color.white);
        this.operatorPanel = new JPanel();
        this.operatorPanel.setLayout(new BoxLayout(this.operatorPanel, 0));
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setAlignmentY(1.0f);
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 0)), "Frequency Domain Operators"));
        this.operatorPanel.setOpaque(false);
        jPanel6.setOpaque(false);
        jPanel6.add(jPanel);
        jPanel6.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel6.add(jPanel2);
        jPanel6.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel6.add(jPanel3);
        jPanel6.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel6.add(jPanel4);
        this.operatorPanel.add(this.leftPanel);
        this.createFourierPanel();
        this.leftPanel.add((Component)jPanel6, "North");
        this.leftPanel.add((Component)jPanel5, "Center");
        this.leftPanel.add((Component)this.imagesPanel, "South");
        this.loadPanel.setBackground(Color.white);
        this.operatorPanel.setBackground(Color.white);
        this.fourierPanel.setBackground(Color.white);
        this.container.add((Component)this.loadPanel, "North");
        this.container.add((Component)this.operatorPanel, "Center");
        this.container.add((Component)this.fourierPanel, "East");
    }

    public void setOperation() {
        this.notch.notchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FFTInterface.this.fourierPane.getTabCount() == 1) {
                    JOptionPane.showMessageDialog(null, "Must Apply Fourier Transform First", "No Fourier Transform Result", 2);
                } else if (FFTInterface.this.notch.getWidth() / 2 != 0 && FFTInterface.this.notch.getRadius() != 0) {
                    FFTInterface.this.fft.intermediate = NotchFilter.notch(FFTInterface.this.fft.intermediate, FFTInterface.this.notch.getWidth() / 2, FFTInterface.this.notch.getRadius());
                    FFTInterface.this.updateFourierImages();
                    FFTInterface.this.updateTabs();
                }
            }
        });
        this.freq.filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FFTInterface.this.fourierPane.getTabCount() == 1) {
                    JOptionPane.showMessageDialog(null, "Must Apply Fourier Transform First", "No Fourier Transform Result", 2);
                } else if (FFTInterface.this.freq.getRadius() != 0) {
                    FFTInterface.this.fft.intermediate = FreqFilter.filter(FFTInterface.this.fft.intermediate, FFTInterface.this.freq.getHighLow(), FFTInterface.this.freq.getRadius());
                    FFTInterface.this.updateFourierImages();
                    FFTInterface.this.updateTabs();
                }
            }
        });
        this.coordNotch.notchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FFTInterface.this.fourierPane.getTabCount() == 1) {
                    JOptionPane.showMessageDialog(null, "Must Apply Fourier Transform First", "No Fourier Transform Result", 2);
                } else {
                    int[] nArray = new int[4];
                    nArray = FFTInterface.this.coordNotch.getCoords(FFTInterface.this.fft.input.size);
                    if (nArray[0] < FFTInterface.this.fft.input.size / 2 - FFTInterface.this.fft.input.size || nArray[1] < FFTInterface.this.fft.input.size / 2 - FFTInterface.this.fft.input.size || nArray[2] < FFTInterface.this.fft.input.size / 2 - FFTInterface.this.fft.input.size || nArray[3] < FFTInterface.this.fft.input.size / 2 - FFTInterface.this.fft.input.size || nArray[0] > FFTInterface.this.fft.input.size / 2 || nArray[1] > FFTInterface.this.fft.input.size / 2 || nArray[2] > FFTInterface.this.fft.input.size / 2 || nArray[3] > FFTInterface.this.fft.input.size / 2) {
                        JOptionPane.showMessageDialog(null, "Coordinates out of bounds.", "Invalid Value", 2);
                    } else {
                        FFTInterface.this.fft.intermediate = DefinableNotch.filter(FFTInterface.this.fft.intermediate, nArray, 0);
                        FFTInterface.this.updateFourierImages();
                        FFTInterface.this.updateTabs();
                    }
                }
            }
        });
        this.coordNotch.notchKeepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FFTInterface.this.fourierPane.getTabCount() == 1) {
                    JOptionPane.showMessageDialog(null, "Must Apply Fourier Transform First", "No Fourier Transform Result", 2);
                } else {
                    int[] nArray = new int[4];
                    nArray = FFTInterface.this.coordNotch.getCoords(FFTInterface.this.fft.input.size);
                    if (nArray[0] < 0 || nArray[1] < 0 || nArray[2] < 0 || nArray[3] < 0 || nArray[0] > FFTInterface.this.fft.input.size || nArray[1] > FFTInterface.this.fft.input.size || nArray[2] > FFTInterface.this.fft.input.size || nArray[3] > FFTInterface.this.fft.input.size) {
                        JOptionPane.showMessageDialog(null, "Coordinates out of bounds.", "Invalid Value", 2);
                    } else {
                        FFTInterface.this.fft.intermediate = DefinableNotch.filter(FFTInterface.this.fft.intermediate, nArray, 1);
                        FFTInterface.this.updateFourierImages();
                        FFTInterface.this.updateTabs();
                    }
                }
            }
        });
        this.gaussian.smooth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FFTInterface.this.fourierPane.getTabCount() == 1) {
                    JOptionPane.showMessageDialog(null, "Must Apply Fourier Transform First", "No Fourier Transform Result", 2);
                } else {
                    double d = FFTInterface.this.gaussian.getSize();
                    int n = FFTInterface.this.gaussian.getX();
                    int n2 = FFTInterface.this.gaussian.getY();
                    if (!(d < 0.0) && n < 1000000 && n2 < 1000000) {
                        FFTInterface.this.fft.intermediate = Gaussian.smooth(FFTInterface.this.fft.intermediate, n, n2, d);
                        FFTInterface.this.updateFourierImages();
                        FFTInterface.this.updateTabs();
                    }
                }
            }
        });
    }

    public void init() {
        this.setLook();
        this.setContainer();
        this.initialImage("cln1.gif");
        this.initialiseImages();
        this.setOperation();
    }

    public String getAppletInfo() {
        return "An applet for applying the FFT, various intermediate operations and the inverse FFT to an image.  Author Simon Horne.";
    }

    public class horizontalAxis
    extends JPanel {
        int size;

        public horizontalAxis(int n) {
            this.size = n;
        }

        public void paint(Graphics graphics) {
            graphics.drawLine(39, 0, 295, 0);
            graphics.drawLine(39, 0, 39, 10);
            graphics.drawLine(104, 0, 104, 5);
            graphics.drawLine(168, 0, 168, 10);
            graphics.drawLine(232, 0, 232, 5);
            graphics.drawLine(295, 0, 295, 10);
            int n = -this.size + this.size / 2;
            int n2 = n + this.size / 4;
            int n3 = 0;
            int n4 = this.size + n + n2;
            int n5 = this.size + n - 1;
            graphics.drawString(Integer.toString(n), 20, 25);
            graphics.drawString(Integer.toString(n2), 92, 25);
            graphics.drawString(Integer.toString(n3), 162, 25);
            graphics.drawString(Integer.toString(n4), 220, 25);
            graphics.drawString(Integer.toString(n5), 280, 25);
        }
    }

    public class verticalAxis
    extends JPanel {
        int size;

        public verticalAxis(int n) {
            this.size = n;
        }

        public void paint(Graphics graphics) {
            graphics.drawLine(39, 0, 39, 255);
            graphics.drawLine(29, 0, 39, 0);
            graphics.drawLine(34, 64, 39, 64);
            graphics.drawLine(29, 128, 39, 128);
            graphics.drawLine(34, 192, 39, 192);
            graphics.drawLine(29, 256, 39, 256);
            int n = -this.size + this.size / 2;
            int n2 = n + this.size / 4;
            int n3 = 0;
            int n4 = this.size + n + n2;
            int n5 = this.size + n - 1;
            graphics.drawString(Integer.toString(n5), 0, 15);
            graphics.drawString(Integer.toString(n4), 0, 74);
            graphics.drawString(Integer.toString(n3), 10, 138);
            graphics.drawString(Integer.toString(n2), 0, 202);
            graphics.drawString(Integer.toString(n), 0, 256);
        }
    }
}

