/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

public class SingleInputImageInterface
extends JApplet {
    public Container container;
    public JPanel imagesPanel;
    public JPanel startstopPanel;
    public JPanel loadPanel;
    public JPanel operatorPanel;
    public JPanel inputPanel;
    public JPanel outputPanel;
    public JTextField imageNameField;
    public String imageName;
    public JLabel status;
    public Image inputImage;
    public MediaTracker tracker;
    public Image outputImage;
    public ImageIcon inputIcon;
    public JLabel inputLabel;
    JLabel inputPixel;
    JLabel outputPixel;
    public JLabel inputDims;
    public ImageIcon outputIcon;
    public JLabel outputLabel;
    public JLabel outputDims;
    public int[] inputArray;
    public int[] outputArray;
    public int inputHeight;
    public int inputWidth;
    public int outputHeight;
    public int outputWidth;
    public long time_msec;
    public JButton load;
    public StartStopInterface startstop;
    public ImageTools imageTools = new ImageTools();

    public void initialImage(String string) {
        this.imageName = new String(string);
        this.imageNameField.setText(string);
    }

    public void updateOutput(Image image2, int n, int n2) {
        this.outputIcon = new ImageIcon(image2);
        this.outputLabel.setIcon(this.imageTools.scaleImage(this.outputIcon));
        this.outputWidth = n;
        this.outputHeight = n2;
        if (this.outputWidth == -1) {
            this.outputDims.setText("No image");
        } else {
            this.outputDims.setText(this.outputWidth + " x " + this.outputHeight);
        }
    }

    public void initialiseInput(Image image2) {
        this.updateInput(image2);
        this.outputArray = (int[])this.inputArray.clone();
    }

    public void updateInput(Image image2) {
        this.inputIcon = new ImageIcon(image2);
        this.inputLabel.setIcon(this.imageTools.scaleImage(this.inputIcon));
        this.inputWidth = this.imageTools.getWidth(this.inputIcon);
        this.inputHeight = this.imageTools.getHeight(this.inputIcon);
        this.inputArray = this.imageTools.examineInput(this.inputIcon);
        if (this.inputWidth == -1) {
            this.inputDims.setText("No image");
        } else {
            this.inputDims.setText(this.inputWidth + " x " + this.inputHeight);
        }
    }

    public boolean initialiseImages() {
        try {
            URL uRL = null;
            this.status.setText("Loading");
            try {
                uRL = new URL(this.imageName);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = new URL(this.getDocumentBase(), "images/" + this.imageName);
                }
                catch (MalformedURLException malformedURLException2) {
                    JOptionPane.showMessageDialog(null, "File not found", "Load Error", 2);
                    return false;
                }
            }
            this.tracker = new MediaTracker(this);
            this.tracker.addImage(this.inputImage, 1);
            this.inputImage = this.getImage(uRL);
            this.tracker.waitForID(1);
            this.initialiseInput(this.inputImage);
            if (this.inputHeight == -1) {
                JOptionPane.showMessageDialog(null, "File not found - " + this.imageName, "File not found", 1);
                this.status.setText("File not found, or not gif/jpg file");
                return false;
            }
            this.status.setText("Image loaded successfully");
            this.updateOutput(this.inputImage, this.inputWidth, this.inputHeight);
            return true;
        }
        catch (InterruptedException interruptedException) {
            this.status.setText("Error loading file");
            return false;
        }
    }

    public JPanel createLoadPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel("Input Image  ");
        this.imageNameField = new JTextField(20);
        this.imageNameField.setToolTipText("The input file name");
        this.load = new JButton("Load Image");
        this.load.setToolTipText("Click here to load image");
        this.status = new JLabel("Load complete");
        this.status.setToolTipText("What's happening with the file?");
        this.imageNameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleInputImageInterface.this.imageName = actionEvent.getActionCommand();
                boolean bl = SingleInputImageInterface.this.initialiseImages();
            }
        });
        this.load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleInputImageInterface.this.imageName = SingleInputImageInterface.this.imageNameField.getText();
                boolean bl = SingleInputImageInterface.this.initialiseImages();
            }
        });
        jPanel.add(this.load);
        jPanel.add(jLabel);
        jPanel.add(this.imageNameField);
        jPanel.add(this.status);
        return jPanel;
    }

    public JPanel createImagesPanel() {
        this.imageName = "brg1.gif";
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setOpaque(false);
        this.inputPanel = new JPanel();
        this.inputPanel.setLayout(new BoxLayout(this.inputPanel, 1));
        this.inputPanel.setOpaque(false);
        JLabel jLabel = new JLabel("Input Image");
        this.inputLabel = new JLabel("");
        CoordinatesListener coordinatesListener = new CoordinatesListener();
        this.inputLabel.addMouseMotionListener(coordinatesListener);
        this.inputLabel.setToolTipText("The input image");
        this.inputPanel.add(jLabel);
        this.inputPanel.add(this.inputLabel);
        this.inputDims = new JLabel();
        this.inputPixel = new JLabel("X  Y  Value");
        this.inputPanel.add(this.inputDims);
        this.inputPanel.add(this.inputPixel);
        this.outputPanel = new JPanel();
        this.outputPanel.setLayout(new BoxLayout(this.outputPanel, 1));
        this.outputPanel.setOpaque(false);
        JLabel jLabel2 = new JLabel("Output Image");
        this.outputLabel = new JLabel("");
        CoordinatesListener coordinatesListener2 = new CoordinatesListener();
        this.outputLabel.addMouseMotionListener(coordinatesListener2);
        this.outputLabel.setToolTipText("The output image");
        this.outputPanel.add(jLabel2);
        this.outputPanel.add(this.outputLabel);
        this.outputDims = new JLabel();
        this.outputPixel = new JLabel("X  Y  Value");
        this.outputPanel.add(this.outputDims);
        this.outputPanel.add(this.outputPixel);
        this.outputHeight = this.inputHeight;
        this.outputWidth = this.inputWidth;
        boolean bl = this.initialiseImages();
        jPanel.add(this.inputPanel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(this.outputPanel);
        return jPanel;
    }

    public void setLook() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setContainer() {
        this.container = this.getContentPane();
        this.container.setLayout(new BoxLayout(this.container, 1));
        this.container.setBackground(Color.white);
        this.startstop = new StartStopInterface();
        this.loadPanel = this.createLoadPanel();
        this.imagesPanel = this.createImagesPanel();
        this.startstopPanel = this.startstop.createPanel();
        this.operatorPanel = new JPanel();
        this.operatorPanel.setLayout(new BoxLayout(this.operatorPanel, 1));
        this.operatorPanel.setOpaque(false);
        this.operatorPanel.setBorder(BorderFactory.createEmptyBorder(10, 50, 10, 50));
        this.container.add(this.loadPanel);
        this.container.add(this.operatorPanel);
        this.container.add(this.startstopPanel);
        this.container.add(this.imagesPanel);
    }

    public void init() {
        this.setLook();
        this.setContainer();
    }

    public String getAppletInfo() {
        return "The superclass of several non-binary image operators.  The superclass of the superclass of the binary image operators.  Written by Simon Horne.";
    }

    class CoordinatesListener
    extends MouseInputAdapter {
        CoordinatesListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            double d = mouseEvent.getX();
            double d2 = mouseEvent.getY();
            double d3 = d / 256.0 * (double)SingleInputImageInterface.this.inputWidth;
            double d4 = d2 / 256.0 * (double)SingleInputImageInterface.this.inputHeight;
            int n = (int)Math.round(d3);
            int n2 = (int)Math.round(d4);
            if (mouseEvent.getComponent() == SingleInputImageInterface.this.inputLabel) {
                int n3 = new Color(SingleInputImageInterface.this.inputArray[n2 * SingleInputImageInterface.this.inputWidth + n]).getRed();
                SingleInputImageInterface.this.inputPixel.setText("X " + n + " Y " + n2 + " Value " + n3);
            } else if (mouseEvent.getComponent() == SingleInputImageInterface.this.outputLabel) {
                int n4 = new Color(SingleInputImageInterface.this.outputArray[n2 * SingleInputImageInterface.this.inputWidth + n]).getRed();
                SingleInputImageInterface.this.outputPixel.setText("X " + n + " Y " + n2 + " Value " + n4);
            }
        }
    }
}

