/*
 * Decompiled with CFR 0.152.
 */
public class Log {
    Convolution convolution = new Convolution();
    int[] input;
    int[] output;
    public int width;
    public int height;
    public int width2;
    public int height2;
    double[][] logKernel;
    double[][] input2D;
    double[][] output2D;
    double theta;
    int kernelSize;

    public Log(int n, double d) {
        this.kernelSize = n;
        this.theta = d;
        this.logKernel = new double[n][n];
        this.generateKernel();
    }

    public boolean kernelValid(double d) {
        double d2 = 0.0;
        double d3 = this.logKernel[0][0];
        for (int i = 0; i < this.kernelSize; ++i) {
            for (int j = 0; j < this.kernelSize; ++j) {
                d2 += this.logKernel[j][i];
            }
        }
        if (d2 > 0.1 || d2 < -0.1 || d <= 0.5 || d / (double)this.kernelSize > 0.09) {
            return false;
        }
        double d4 = d2 / (double)(this.kernelSize * this.kernelSize);
        for (int i = 0; i < this.kernelSize; ++i) {
            for (int j = 0; j < this.kernelSize; ++j) {
                this.logKernel[j][i] = this.logKernel[j][i] - d4;
            }
        }
        return true;
    }

    double logElement(int n, int n2) {
        double d = 0.0;
        for (double d2 = (double)n2 - 0.5; d2 < (double)n2 + 0.55; d2 += 0.1) {
            for (double d3 = (double)n - 0.5; d3 < (double)n + 0.55; d3 += 0.1) {
                double d4 = -(d3 * d3 + d2 * d2) / (2.0 * this.theta * this.theta);
                d += 1.0 / (Math.PI * Math.pow(this.theta, 4.0)) * (1.0 + d4) * Math.pow(Math.E, d4);
            }
        }
        d = -d / 121.0;
        return d;
    }

    void generateKernel() {
        for (int i = 0; i < this.kernelSize; ++i) {
            for (int j = 0; j < this.kernelSize; ++j) {
                int n = -this.kernelSize / 2 + j;
                int n2 = -this.kernelSize / 2 + i;
                this.logKernel[j][i] = this.logElement(n, n2);
            }
        }
    }

    public int[] log_image(int[] nArray, int n, int n2, double d, double d2) {
        nArray = Convolution.convolution_image(nArray, n, n2, this.logKernel, this.kernelSize, this.kernelSize, d, d2);
        return nArray;
    }
}

