/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class SReflectScreen
extends VisionApplet1 {
    public ReflectImageCanvas src_canvas;
    private boolean wrap;
    private Reflect reflect;
    Point point = null;
    private ButtonListener startbl = new ButtonListener();
    private ButtonListener abortbl = new ButtonListener();
    private SliderListener slangle = new SliderListener();
    private TextListener angletl = new TextListener();
    private JButton startbutton = new JButton("Reflect");
    private JButton abortbutton = new JButton("Stop");
    private JLabel time = new JLabel("Time");
    private JLabel anglelabel = new JLabel("Angle of axis");
    private JTextField angle_text = new JTextField(3);
    private JSlider angle_slide = new JSlider(0, 0, 180, 0);
    private JTextField time_taken = new JTextField(30);

    public void add_extra() {
        this.wrap = false;
        this.reflect = new Reflect();
        this.midc.weighty = 0.5;
        this.midc.gridx = 0;
        this.midc.gridy = 0;
        this.midlayout.setConstraints(this.anglelabel, this.midc);
        this.mid.add(this.anglelabel);
        this.midc.gridx = 0;
        this.midc.gridy = 1;
        this.midlayout.setConstraints(this.angle_text, this.midc);
        this.mid.add(this.angle_text);
        this.angle_text.setText("0");
        this.angle_text.addKeyListener(this.angletl);
        this.midc.gridx = 1;
        this.midc.gridy = 1;
        this.midc.fill = 2;
        this.midlayout.setConstraints(this.angle_slide, this.midc);
        this.mid.add(this.angle_slide);
        this.angle_slide.setBackground(Color.white);
        this.angle_slide.setMajorTickSpacing(20);
        this.angle_slide.setMinorTickSpacing(1);
        this.angle_slide.setPaintTicks(true);
        this.angle_slide.setPaintLabels(true);
        this.angle_slide.addChangeListener(this.slangle);
        this.midc.fill = 0;
        this.midc.gridx = 0;
        this.midc.gridy = 2;
        this.midlayout.setConstraints(this.startbutton, this.midc);
        this.startbutton.setBackground(Color.green);
        this.mid.add(this.startbutton);
        this.startbutton.addActionListener(this.startbl);
        this.midc.gridx = -1;
        this.abortbutton.setBackground(Color.red);
        this.midlayout.setConstraints(this.abortbutton, this.midc);
        this.mid.add(this.abortbutton);
        this.abortbutton.addActionListener(this.abortbl);
        this.midc.gridx = 0;
        this.midc.gridy = 3;
        this.midlayout.setConstraints(this.time, this.midc);
        this.mid.add(this.time);
        this.midc.gridx = 1;
        this.midc.gridy = 3;
        this.midlayout.setConstraints(this.time_taken, this.midc);
        this.time_taken.setEditable(false);
        this.mid.add(this.time_taken);
        this.mid.repaint();
    }

    public void set_src_image(int[] nArray, int n, int n2, String string) {
        this.i_w = n;
        this.i_h = n2;
        this.src_1d = new int[this.i_w * this.i_h];
        this.src_1d = nArray;
        this.src = this.createImage(new MemoryImageSource(this.i_w, this.i_h, this.src_1d, 0, this.i_w));
        if (this.src_canvas != null) {
            this.bl.remove(this.src_canvas);
        }
        this.src_canvas = new ReflectImageCanvas(this.src);
        this.blc.gridx = 0;
        this.blc.gridy = 1;
        this.bllayout.setConstraints(this.src_canvas, this.blc);
        this.bl.add(this.src_canvas);
        this.bl.validate();
        this.bl.repaint();
        this.insize.setText(this.i_w + " x " + this.i_h);
        MyMouseListener myMouseListener = new MyMouseListener();
        this.src_canvas.addMouseListener(myMouseListener);
        this.src_canvas.addMouseMotionListener(myMouseListener);
        this.blPosition.setText("Point X:  Y: ");
        this.blIntensity.setText("Intensity: ");
        this.angle_slide.setValue(0);
        this.angle_text.setText("0");
        this.reflect = new Reflect();
        this.d_w = this.i_w;
        this.d_h = this.i_h;
        this.dest_1d = new int[this.i_w * this.i_h];
        this.dest_1d = nArray;
        this.dest = this.createImage(new MemoryImageSource(this.d_w, this.d_h, this.dest_1d, 0, this.d_w));
        if (this.dest_canvas != null) {
            this.br.remove(this.dest_canvas);
        }
        this.dest_canvas = new ImageCanvas(this.dest);
        VisionApplet1.PixelListener pixelListener = new VisionApplet1.PixelListener(this);
        this.dest_canvas.addMouseMotionListener(pixelListener);
        this.brPosition.setText("Point X:  Y: ");
        this.brIntensity.setText("Intensity: ");
        this.brc.gridx = 0;
        this.brc.gridy = 1;
        this.brlayout.setConstraints(this.dest_canvas, this.brc);
        this.br.add(this.dest_canvas);
        this.outsize.setText(this.d_w + " x " + this.d_h);
        this.container.validate();
        this.container.repaint();
    }

    public void set_image() {
        Object object;
        String string = "brg1.gif";
        try {
            object = new URL(this.getDocumentBase(), "images/" + string);
            this.src = this.getImage((URL)object);
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(null, "The default file is not present", "Load Error", 2);
            return;
        }
        this.src_canvas = new ReflectImageCanvas(this.src);
        this.dest_canvas = new ImageCanvas(this.src);
        this.i_w = this.src_canvas.getImageWidth();
        this.i_h = this.src_canvas.getImageHeight();
        this.src_1d = new int[this.i_w * this.i_h];
        object = new PixelGrabber(this.src, 0, 0, this.i_w, this.i_h, this.src_1d, 0, this.i_w);
        try {
            ((PixelGrabber)object).grabPixels();
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(null, "Unable to handle default file", "Load Error", 2);
            return;
        }
        if ((((PixelGrabber)object).status() & 0x80) != 0) {
            JOptionPane.showMessageDialog(null, "The default iamge file cannot be loaded", "Load Error", 2);
            return;
        }
        this.d_w = this.i_w;
        this.d_h = this.i_h;
        this.dest_1d = new int[this.d_w * this.d_h];
        for (int i = 0; i < this.dest_1d.length; ++i) {
            this.dest_1d[i] = this.src_1d[i];
        }
    }

    public void gui_add_image() {
        this.blc.gridx = 0;
        this.blc.gridy = 1;
        this.bllayout.setConstraints(this.src_canvas, this.blc);
        this.bl.add(this.src_canvas);
        MyMouseListener myMouseListener = new MyMouseListener();
        this.src_canvas.addMouseListener(myMouseListener);
        this.src_canvas.addMouseMotionListener(myMouseListener);
        this.brc.gridx = 0;
        this.brc.gridy = 1;
        this.brlayout.setConstraints(this.dest_canvas, this.brc);
        this.br.add(this.dest_canvas);
        this.dest_canvas.addMouseMotionListener(this.brpl);
    }

    public void apply_send_image() {
        MediaTracker mediaTracker = new MediaTracker(this);
        Image image = this.getImage(this.theURL);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        if (mediaTracker.statusID(0, false) == 4) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        ReflectImageCanvas reflectImageCanvas = new ReflectImageCanvas(image);
        int n = reflectImageCanvas.getImageWidth();
        int n2 = reflectImageCanvas.getImageHeight();
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        if ((pixelGrabber.status() & 0x80) != 0) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        this.set_src_image(nArray, n, n2, this.image_url);
    }

    public String getAppletInfo() {
        return "An applet for applying reflection to an image. Written by Craig Strachan, heavily based on code by Judy Robertson, SELLIC OnLine, Timothy Sharman";
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (jSlider == SReflectScreen.this.angle_slide) {
                SReflectScreen.this.angle_text.setText(String.valueOf(SReflectScreen.this.angle_slide.getValue()));
                SReflectScreen.this.src_canvas.angle = SReflectScreen.this.angle_slide.getValue();
                SReflectScreen.this.src_canvas.paint(SReflectScreen.this.src_canvas.getGraphics());
            }
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == SReflectScreen.this.startbutton) {
                SReflectScreen.this.angle_text.setText(String.valueOf(SReflectScreen.this.angle_slide.getValue()));
                SReflectScreen.this.time_msec = System.currentTimeMillis();
                SReflectScreen.this.dest_1d = SReflectScreen.this.reflect.reflect_image(SReflectScreen.this.src_1d, SReflectScreen.this.i_w, SReflectScreen.this.i_h, SReflectScreen.this.src_canvas.x, SReflectScreen.this.src_canvas.y, SReflectScreen.this.src_canvas.angle, SReflectScreen.this.wrap);
                SReflectScreen.this.time_msec = System.currentTimeMillis() - SReflectScreen.this.time_msec;
                SReflectScreen.this.time_taken.setText(new Long(SReflectScreen.this.time_msec).toString() + " msecs");
                SReflectScreen.this.dest = SReflectScreen.this.createImage(new MemoryImageSource(SReflectScreen.this.i_w, SReflectScreen.this.i_h, SReflectScreen.this.dest_1d, 0, SReflectScreen.this.i_w));
                if (SReflectScreen.this.dest_canvas != null) {
                    SReflectScreen.this.br.remove(SReflectScreen.this.dest_canvas);
                }
                SReflectScreen.this.dest_canvas = new ImageCanvas(SReflectScreen.this.dest);
                VisionApplet1.PixelListener pixelListener = new VisionApplet1.PixelListener(SReflectScreen.this);
                SReflectScreen.this.dest_canvas.addMouseMotionListener(pixelListener);
                SReflectScreen.this.brc.gridx = 0;
                SReflectScreen.this.brc.gridy = 1;
                SReflectScreen.this.brlayout.setConstraints(SReflectScreen.this.dest_canvas, SReflectScreen.this.brc);
                SReflectScreen.this.br.add(SReflectScreen.this.dest_canvas);
                SReflectScreen.this.br.validate();
                SReflectScreen.this.br.doLayout();
                SReflectScreen.this.container.validate();
            } else if (jButton == SReflectScreen.this.abortbutton) {
                SReflectScreen.this.time_taken.setText("");
            }
        }
    }

    class MyMouseListener
    extends MouseInputAdapter {
        MyMouseListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ReflectImageCanvas reflectImageCanvas = (ReflectImageCanvas)mouseEvent.getSource();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            int n4 = 0;
            int n5 = reflectImageCanvas.getImageWidth();
            int n6 = reflectImageCanvas.getImageHeight();
            if (n5 >= 256 || n6 >= 256) {
                float f;
                if (n5 > n6) {
                    f = (float)n5 / (float)n6;
                    n3 = 256;
                    n4 = (int)(256.0f / f);
                    SReflectScreen.this.actualx = (int)((float)n5 / (float)n3 * (float)n);
                    SReflectScreen.this.actualy = (int)((float)n6 / (float)n4 * (float)n2);
                } else if (n6 > n5) {
                    f = (float)n6 / (float)n5;
                    n3 = n5;
                    n4 = 256;
                    n3 = (int)(256.0f / f);
                    SReflectScreen.this.actualx = (int)((float)n5 / (float)n3 * (float)n);
                    SReflectScreen.this.actualy = (int)((float)n6 / (float)n4 * (float)n2);
                } else {
                    SReflectScreen.this.actualx = (int)((float)n5 / 256.0f * (float)n);
                    SReflectScreen.this.actualy = (int)((float)n6 / 256.0f * (float)n2);
                }
            } else {
                SReflectScreen.this.actualx = n;
                SReflectScreen.this.actualy = n2;
            }
            if (SReflectScreen.this.actualx < 0) {
                SReflectScreen.this.actualx = 0;
            }
            if (SReflectScreen.this.actualy < 0) {
                SReflectScreen.this.actualy = 0;
            }
            if (SReflectScreen.this.actualx > n5 - 1) {
                SReflectScreen.this.actualx = n5 - 1;
            }
            if (SReflectScreen.this.actualy > n6 - 1) {
                SReflectScreen.this.actualy = n6 - 1;
            }
            int n7 = SReflectScreen.this.src_1d[SReflectScreen.this.actualx + SReflectScreen.this.actualy * n5] & 0xFF;
            SReflectScreen.this.blPosition.setText("Point X:" + SReflectScreen.this.actualx + "  Y:" + SReflectScreen.this.actualy);
            SReflectScreen.this.blIntensity.setText("Intensity:" + n7);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ReflectImageCanvas reflectImageCanvas = (ReflectImageCanvas)mouseEvent.getSource();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (SReflectScreen.this.point == null) {
                SReflectScreen.this.point = new Point(n, n2);
            } else {
                SReflectScreen.this.point.x = n;
                SReflectScreen.this.point.y = n2;
            }
            reflectImageCanvas.setLineCenter(SReflectScreen.this.point.x, SReflectScreen.this.point.y);
        }
    }

    class TextListener
    extends KeyAdapter {
        TextListener() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            block4: {
                JTextField jTextField = (JTextField)keyEvent.getSource();
                try {
                    int n = Integer.valueOf(jTextField.getText());
                    if (n >= 0 && n <= 180) {
                        SReflectScreen.this.angle_slide.setValue(n);
                    } else {
                        JOptionPane.showMessageDialog(null, "Angle of reflectance must lie between 0 and 180", "Error!", 2);
                        SReflectScreen.this.angle_slide.setValue(0);
                        SReflectScreen.this.angle_text.setText("0");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (jTextField.getText().equals("")) break block4;
                    JOptionPane.showMessageDialog(null, "Invalid angle specified", "Error!", 2);
                }
            }
        }
    }
}

