/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VisionApplet1
extends JApplet {
    public Container container = null;
    public Image src;
    public Image dest;
    public ImageCanvas src_canvas;
    public ImageCanvas dest_canvas;
    public int[] src_1d;
    public int[] dest_1d;
    public int i_w;
    public int i_h;
    public int d_w;
    public int d_h;
    public int actualx;
    public int actualy;
    public long time_msec;
    private GridBagLayout layout = new GridBagLayout();
    private GridBagLayout loadlayout = new GridBagLayout();
    public GridBagLayout midlayout = new GridBagLayout();
    public GridBagLayout brlayout = new GridBagLayout();
    public GridBagLayout bllayout = new GridBagLayout();
    private GridBagConstraints wholec = new GridBagConstraints();
    private GridBagConstraints loadc = new GridBagConstraints();
    public GridBagConstraints midc = new GridBagConstraints();
    public GridBagConstraints blc = new GridBagConstraints();
    public GridBagConstraints brc = new GridBagConstraints();
    private JPanel top = new JPanel();
    public JPanel mid = new JPanel();
    public JPanel br = new JPanel();
    public JPanel bl = new JPanel();
    public JButton load_image = new JButton("Load image");
    public JTextField input = new JTextField(30);
    private JLabel inputlab = new JLabel("Input");
    public JLabel output = new JLabel("Output");
    public JLabel insize = new JLabel();
    public JLabel outsize = new JLabel();
    public JLabel blPosition = new JLabel("Point X:  Y: ");
    public JLabel brPosition = new JLabel("Point X:  Y: ");
    public JLabel blIntensity = new JLabel("Intensity: ");
    public JLabel brIntensity = new JLabel("Intensity: ");
    public PixelListener blpl = new PixelListener();
    public PixelListener brpl = new PixelListener();
    private LoadListener ll = new LoadListener();
    public URL theURL;
    public String image_url = "brg1.gif";

    public void init() {
        this.container = this.getContentPane();
        this.container.setLayout(this.layout);
        this.container.setBackground(Color.white);
        this.set_image();
        this.set_interface();
        this.add_extra();
        this.gui_add_image();
    }

    public void set_image() {
        Object object;
        String string = "brg1.gif";
        try {
            object = new URL(this.getDocumentBase(), "images/" + string);
            this.src = this.getImage((URL)object);
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(null, "The default file is not present", "Load Error", 2);
            return;
        }
        this.src_canvas = new ImageCanvas(this.src);
        this.dest_canvas = new ImageCanvas(this.src);
        this.i_w = this.src_canvas.getImageWidth();
        this.i_h = this.src_canvas.getImageHeight();
        this.src_1d = new int[this.i_w * this.i_h];
        object = new PixelGrabber(this.src, 0, 0, this.i_w, this.i_h, this.src_1d, 0, this.i_w);
        try {
            ((PixelGrabber)object).grabPixels();
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(null, "Unable to handle default file", "Load Error", 2);
            return;
        }
        if ((((PixelGrabber)object).status() & 0x80) != 0) {
            JOptionPane.showMessageDialog(null, "The default image file cannot be loaded", "Load Error", 2);
            return;
        }
        this.d_w = this.i_w;
        this.d_h = this.i_h;
        this.dest_1d = new int[this.d_w * this.d_h];
        for (int i = 0; i < this.dest_1d.length; ++i) {
            this.dest_1d[i] = this.src_1d[i];
        }
    }

    public void set_interface() {
        PixelListener pixelListener = new PixelListener();
        PixelListener pixelListener2 = new PixelListener();
        this.top.setLayout(this.loadlayout);
        this.top.setBackground(Color.white);
        this.loadc.fill = 1;
        this.loadlayout.setConstraints(this.load_image, this.loadc);
        this.top.add(this.load_image);
        this.loadc.gridwidth = 0;
        this.loadlayout.setConstraints(this.input, this.loadc);
        this.top.add(this.input);
        this.input.setText(this.image_url);
        this.load_image.addActionListener(this.ll);
        this.mid.setLayout(this.midlayout);
        this.mid.setBackground(Color.white);
        this.br.setLayout(this.brlayout);
        this.br.setBackground(Color.white);
        this.brc.gridx = 0;
        this.brc.gridy = 0;
        this.brlayout.setConstraints(this.output, this.brc);
        this.br.add(this.output);
        this.brc.gridx = 0;
        this.brc.gridy = 2;
        this.brlayout.setConstraints(this.outsize, this.brc);
        this.outsize.setText(this.d_w + " x " + this.d_h);
        this.br.add(this.outsize);
        this.brc.gridx = 0;
        this.brc.gridy = 3;
        this.brlayout.setConstraints(this.brPosition, this.brc);
        this.br.add(this.brPosition);
        this.brc.gridx = 0;
        this.brc.gridy = 4;
        this.brlayout.setConstraints(this.brIntensity, this.brc);
        this.br.add(this.brIntensity);
        this.bl.setLayout(this.bllayout);
        this.bl.setBackground(Color.white);
        this.blc.gridx = 0;
        this.blc.gridy = 0;
        this.bllayout.setConstraints(this.inputlab, this.blc);
        this.bl.add(this.inputlab);
        this.blc.gridx = 0;
        this.blc.gridy = 2;
        this.bllayout.setConstraints(this.insize, this.blc);
        this.insize.setText(this.i_w + " x " + this.i_h);
        this.bl.add(this.insize);
        this.blc.gridx = 0;
        this.blc.gridy = 3;
        this.bllayout.setConstraints(this.blPosition, this.blc);
        this.bl.add(this.blPosition);
        this.blc.gridx = 0;
        this.blc.gridy = 4;
        this.bllayout.setConstraints(this.blIntensity, this.blc);
        this.bl.add(this.blIntensity);
        this.wholec.gridx = 0;
        this.wholec.gridy = 0;
        this.wholec.gridwidth = 3;
        this.wholec.fill = 1;
        this.wholec.weightx = 0.3;
        this.wholec.weighty = 0.2;
        this.layout.setConstraints(this.top, this.wholec);
        this.container.add(this.top);
        this.wholec.gridwidth = 2;
        this.wholec.gridx = 0;
        this.wholec.gridy = 1;
        this.layout.setConstraints(this.mid, this.wholec);
        this.container.add(this.mid);
        this.wholec.gridwidth = 1;
        this.wholec.gridx = 0;
        this.wholec.gridy = 2;
        this.layout.setConstraints(this.bl, this.wholec);
        this.container.add(this.bl);
        this.wholec.gridx = 1;
        this.wholec.gridy = 2;
        this.layout.setConstraints(this.br, this.wholec);
        this.container.add(this.br);
    }

    public void add_extra() {
    }

    public void gui_add_image() {
        this.blc.gridx = 0;
        this.blc.gridy = 1;
        this.bllayout.setConstraints(this.src_canvas, this.blc);
        this.bl.add(this.src_canvas);
        this.src_canvas.addMouseMotionListener(this.blpl);
        this.brc.gridx = 0;
        this.brc.gridy = 1;
        this.brlayout.setConstraints(this.dest_canvas, this.brc);
        this.br.add(this.dest_canvas);
        this.dest_canvas.addMouseMotionListener(this.brpl);
    }

    public void set_src_image2(int[] nArray, int n, int n2, String string) {
        this.i_w = n;
        this.i_h = n2;
        this.src_1d = new int[this.i_w * this.i_h];
        this.src_1d = nArray;
        this.src = this.createImage(new MemoryImageSource(this.i_w, this.i_h, this.src_1d, 0, this.i_w));
        this.src_canvas.updateImage(this.src);
        this.insize.setText(this.i_w + " x " + this.i_h);
        this.d_w = this.i_w;
        this.d_h = this.i_h;
        this.dest_1d = new int[this.d_w * this.d_h];
        this.dest_1d = nArray;
        this.dest = this.createImage(new MemoryImageSource(this.d_w, this.d_h, this.dest_1d, 0, this.d_w));
        this.dest_canvas.updateImage(this.dest);
        this.outsize.setText(this.d_w + " x " + this.d_h);
        PixelListener pixelListener = new PixelListener();
        PixelListener pixelListener2 = new PixelListener();
        this.src_canvas.addMouseMotionListener(pixelListener);
        this.dest_canvas.addMouseMotionListener(pixelListener2);
        this.blPosition.setText("Point X:  Y: ");
        this.blIntensity.setText("Intensity: ");
        this.brPosition.setText("Point X:  Y: ");
        this.brIntensity.setText("Intensity: ");
        this.container.validate();
        this.container.repaint();
    }

    public void set_src_image(int[] nArray, int n, int n2, String string) {
        this.set_src_image2(nArray, n, n2, string);
    }

    public void apply_send_image() {
        MediaTracker mediaTracker = new MediaTracker(this);
        Image image = this.getImage(this.theURL);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        if (mediaTracker.statusID(0, false) == 4) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        ImageCanvas imageCanvas = new ImageCanvas(image);
        int n = imageCanvas.getImageWidth();
        int n2 = imageCanvas.getImageHeight();
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        if ((pixelGrabber.status() & 0x80) != 0) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        this.set_src_image(nArray, n, n2, this.image_url);
    }

    public String getAppletInfo() {
        return "An applet for running image processing operators on. Written by Timothy Sharman";
    }

    class LoadListener
    implements ActionListener {
        LoadListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VisionApplet1.this.image_url = VisionApplet1.this.input.getText();
            try {
                VisionApplet1.this.theURL = new URL(VisionApplet1.this.image_url);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    VisionApplet1.this.theURL = new URL(VisionApplet1.this.getDocumentBase(), "images/" + VisionApplet1.this.image_url);
                }
                catch (MalformedURLException malformedURLException2) {
                    JOptionPane.showMessageDialog(null, "File not found", "Load Error", 2);
                    return;
                }
            }
            String string = VisionApplet1.this.theURL.getFile();
            if (!string.endsWith("jpg") && !string.endsWith("gif")) {
                JOptionPane.showMessageDialog(null, "File extension not valid. Use .gif or .jpg", "Load Error", 2);
                return;
            }
            VisionApplet1.this.apply_send_image();
        }
    }

    public class PixelListener
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            ImageCanvas imageCanvas = (ImageCanvas)mouseEvent.getSource();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            int n4 = 0;
            int n5 = imageCanvas.getImageWidth();
            int n6 = imageCanvas.getImageHeight();
            try {
                if (n5 >= 256 || n6 >= 256) {
                    float f;
                    if (n5 > n6) {
                        f = (float)n5 / (float)n6;
                        n3 = 256;
                        n4 = (int)(256.0f / f);
                        VisionApplet1.this.actualx = (int)((float)n5 / (float)n3 * (float)n);
                        VisionApplet1.this.actualy = (int)((float)n6 / (float)n4 * (float)n2);
                    } else if (n6 > n5) {
                        f = (float)n6 / (float)n5;
                        n3 = n5;
                        n4 = 256;
                        n3 = (int)(256.0f / f);
                        VisionApplet1.this.actualx = (int)((float)n5 / (float)n3 * (float)n);
                        VisionApplet1.this.actualy = (int)((float)n6 / (float)n4 * (float)n2);
                    } else {
                        VisionApplet1.this.actualx = (int)((float)n5 / 256.0f * (float)n);
                        VisionApplet1.this.actualy = (int)((float)n6 / 256.0f * (float)n2);
                    }
                } else {
                    VisionApplet1.this.actualx = n;
                    VisionApplet1.this.actualy = n2;
                }
                if (VisionApplet1.this.actualx >= 0 && VisionApplet1.this.actualy >= 0) {
                    if (VisionApplet1.this.actualx > n5 - 1) {
                        VisionApplet1.this.actualx = n5 - 1;
                    }
                    if (VisionApplet1.this.actualy > n6 - 1) {
                        VisionApplet1.this.actualy = n6 - 1;
                    }
                    if (imageCanvas == VisionApplet1.this.src_canvas) {
                        int n7 = VisionApplet1.this.src_1d[VisionApplet1.this.actualx + VisionApplet1.this.actualy * n5] & 0xFF;
                        VisionApplet1.this.blPosition.setText("Point X:" + VisionApplet1.this.actualx + "  Y:" + VisionApplet1.this.actualy);
                        VisionApplet1.this.blIntensity.setText("Intensity:" + n7);
                    }
                    if (imageCanvas == VisionApplet1.this.dest_canvas) {
                        int n8 = VisionApplet1.this.dest_1d[VisionApplet1.this.actualx + VisionApplet1.this.actualy * n5] & 0xFF;
                        VisionApplet1.this.brPosition.setText("Point X:" + VisionApplet1.this.actualx + "  Y:" + VisionApplet1.this.actualy);
                        VisionApplet1.this.brIntensity.setText("Intensity:" + n8);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }
}

