/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class NoScaleImageCanvas
extends JLabel {
    protected int image_width = -1;
    protected int image_height = -1;
    ImageIcon picIcon;
    public ImageTools imageTools = new ImageTools();

    public NoScaleImageCanvas(Image image) {
        this.picIcon = new ImageIcon(image);
        this.image_width = image.getWidth(this);
        this.image_height = image.getHeight(this);
        super.setIcon(this.picIcon);
    }

    public void updateImage(Image image) {
        this.picIcon = new ImageIcon(image);
        this.image_width = image.getWidth(this);
        this.image_height = image.getHeight(this);
        this.setIcon(this.imageScale(this.picIcon));
    }

    public int getImageWidth() {
        return this.image_width;
    }

    public int getImageHeight() {
        return this.image_height;
    }

    public void paint(Graphics graphics) {
        Image image = this.picIcon.getImage();
        graphics.setColor(Color.white);
        graphics.drawImage(image, 1, 1, this);
    }

    public ImageIcon imageScale(ImageIcon imageIcon) {
        Image image = imageIcon.getImage();
        int n = this.image_width;
        int n2 = this.image_height;
        if (this.image_width >= 256 || this.image_height >= 256) {
            if (this.image_width > this.image_height) {
                float f = (float)this.image_width / (float)this.image_height;
                n = 256;
                n2 = (int)(256.0f / f);
            } else if (this.image_height > this.image_width) {
                float f = (float)this.image_height / (float)this.image_width;
                n = this.image_width;
                n2 = 256;
                n = (int)(256.0f / f);
            } else {
                n = 256;
                n2 = 256;
            }
        }
        Image image2 = image.getScaledInstance(n, n2, 1);
        ImageIcon imageIcon2 = new ImageIcon(image2);
        return imageIcon2;
    }
}

