/*
 * Decompiled with CFR 0.152.
 */
public class ComplexNumber {
    public double real;
    public double imaginary;

    public ComplexNumber() {
    }

    public ComplexNumber(double d, double d2) {
        this.real = d;
        this.imaginary = d2;
    }

    public ComplexNumber(ComplexNumber complexNumber) {
        this.real = complexNumber.real;
        this.imaginary = complexNumber.imaginary;
    }

    public double magnitude() {
        return Math.sqrt(this.cNorm());
    }

    public double phaseAngle() {
        if (this.real == 0.0 && this.imaginary == 0.0) {
            return 0.0;
        }
        return Math.atan(this.imaginary / this.real);
    }

    double cNorm() {
        return this.real * this.real + this.imaginary * this.imaginary;
    }

    public static ComplexNumber cExp(ComplexNumber complexNumber) {
        ComplexNumber complexNumber2 = new ComplexNumber(Math.exp(complexNumber.real), 0.0);
        ComplexNumber complexNumber3 = new ComplexNumber(Math.cos(complexNumber.imaginary), Math.sin(complexNumber.imaginary));
        return ComplexNumber.cMult(complexNumber2, complexNumber3);
    }

    public static ComplexNumber cMult(ComplexNumber complexNumber, ComplexNumber complexNumber2) {
        ComplexNumber complexNumber3 = new ComplexNumber();
        complexNumber3.real = complexNumber.real * complexNumber2.real - complexNumber.imaginary * complexNumber2.imaginary;
        complexNumber3.imaginary = complexNumber.real * complexNumber2.imaginary + complexNumber.imaginary * complexNumber2.real;
        return complexNumber3;
    }

    public static ComplexNumber cSum(ComplexNumber complexNumber, ComplexNumber complexNumber2) {
        ComplexNumber complexNumber3 = new ComplexNumber();
        complexNumber3.real = complexNumber.real + complexNumber2.real;
        complexNumber3.imaginary = complexNumber.imaginary + complexNumber2.imaginary;
        return complexNumber3;
    }

    public static ComplexNumber cDiv(ComplexNumber complexNumber, ComplexNumber complexNumber2) {
        ComplexNumber complexNumber3 = new ComplexNumber();
        double d = complexNumber2.cNorm();
        complexNumber3.real = (complexNumber.real * complexNumber2.real + complexNumber.imaginary * complexNumber2.imaginary) / d;
        complexNumber3.imaginary = (complexNumber2.real * complexNumber.imaginary - complexNumber.real * complexNumber2.imaginary) / d;
        return complexNumber3;
    }

    public static ComplexNumber cDif(ComplexNumber complexNumber, ComplexNumber complexNumber2) {
        ComplexNumber complexNumber3 = new ComplexNumber();
        complexNumber3.real = complexNumber.real - complexNumber2.real;
        complexNumber3.imaginary = complexNumber.imaginary - complexNumber2.imaginary;
        return complexNumber3;
    }
}

