/*
 * Decompiled with CFR 0.152.
 */
public class FFT {
    public TwoDArray input;
    public TwoDArray intermediate;
    public TwoDArray output;

    public FFT() {
    }

    public FFT(int[] nArray, int n, int n2) {
        this.input = new TwoDArray(nArray, n, n2);
        this.intermediate = new TwoDArray(nArray, n, n2);
        this.output = new TwoDArray(nArray, n, n2);
        this.transform();
    }

    static ComplexNumber[] recursiveFFT(ComplexNumber[] complexNumberArray) {
        int n = complexNumberArray.length;
        int n2 = n / 2;
        ComplexNumber[] complexNumberArray2 = new ComplexNumber[n];
        ComplexNumber[] complexNumberArray3 = new ComplexNumber[n2];
        ComplexNumber[] complexNumberArray4 = new ComplexNumber[n2];
        ComplexNumber[] complexNumberArray5 = new ComplexNumber[n2];
        ComplexNumber[] complexNumberArray6 = new ComplexNumber[n2];
        ComplexNumber complexNumber = new ComplexNumber(2.0, 0.0);
        if (n == 1) {
            complexNumberArray2[0] = complexNumberArray[0];
        } else {
            int n3;
            ComplexNumber complexNumber2 = new ComplexNumber(0.0, Math.PI * -2 / (double)n);
            ComplexNumber complexNumber3 = ComplexNumber.cExp(complexNumber2);
            complexNumber2 = new ComplexNumber(1.0, 0.0);
            for (n3 = 0; n3 < n2; ++n3) {
                ComplexNumber complexNumber4 = ComplexNumber.cSum(complexNumberArray[n3], complexNumberArray[n3 + n2]);
                complexNumberArray5[n3] = ComplexNumber.cDiv(complexNumber4, complexNumber);
                complexNumber4 = ComplexNumber.cDif(complexNumberArray[n3], complexNumberArray[n3 + n2]);
                ComplexNumber complexNumber5 = ComplexNumber.cMult(complexNumber4, complexNumber2);
                complexNumberArray6[n3] = ComplexNumber.cDiv(complexNumber5, complexNumber);
                ComplexNumber complexNumber6 = ComplexNumber.cMult(complexNumber2, complexNumber3);
                complexNumber2 = new ComplexNumber(complexNumber6);
            }
            complexNumberArray3 = FFT.recursiveFFT(complexNumberArray5);
            complexNumberArray4 = FFT.recursiveFFT(complexNumberArray6);
            for (n3 = 0; n3 < n2; ++n3) {
                complexNumberArray2[n3 * 2] = new ComplexNumber(complexNumberArray3[n3]);
                complexNumberArray2[n3 * 2 + 1] = new ComplexNumber(complexNumberArray4[n3]);
            }
        }
        return complexNumberArray2;
    }

    void transform() {
        int n;
        for (n = 0; n < this.input.size; ++n) {
            this.intermediate.putColumn(n, FFT.recursiveFFT(this.input.getColumn(n)));
        }
        for (n = 0; n < this.intermediate.size; ++n) {
            this.output.putRow(n, FFT.recursiveFFT(this.intermediate.getRow(n)));
        }
        for (n = 0; n < this.output.values.length; ++n) {
            for (int i = 0; i < this.output.values[0].length; ++i) {
                this.intermediate.values[i][n] = this.output.values[i][n];
                this.input.values[i][n] = this.output.values[i][n];
            }
        }
    }
}

