/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StreamTokenizer;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class gaussianSmooth
extends operator1DInt {
    JLabel thetaLabel = new JLabel("Theta Value:");
    JTextField thetaText = new JTextField("0.4", 5);
    JLabel kernelLabel = new JLabel("Kernel Size");
    JPanel p = new JPanel();
    ButtonGroup group = new ButtonGroup();
    JRadioButton size3 = new JRadioButton("3x3");
    JRadioButton size4 = new JRadioButton("4x4");
    JRadioButton size5 = new JRadioButton("5x5");
    JRadioButton size6 = new JRadioButton("6x6");
    JRadioButton size7 = new JRadioButton("7x7");
    GaussianSmooth gaussianSmoothOp = new GaussianSmooth();
    static int number = 0;
    int s = 3;
    double theta;
    String type = new String("GaussianSmoothing");

    public gaussianSmooth() {
    }

    public gaussianSmooth(JPanel jPanel, linkData linkData2) {
        this.setName(this.type + "_" + ++number);
        this.setParameters();
        this.setType(this.type);
        this.setBox(jPanel, linkData2, 1, 1);
    }

    public void loadParameters(StreamTokenizer streamTokenizer) throws IOException {
        int n = streamTokenizer.nextToken();
        this.s = (int)streamTokenizer.nval;
        switch (this.s) {
            case 3: {
                this.size3.setSelected(true);
                break;
            }
            case 4: {
                this.size4.setSelected(true);
                break;
            }
            case 5: {
                this.size5.setSelected(true);
                break;
            }
            case 6: {
                this.size6.setSelected(true);
                break;
            }
            case 7: {
                this.size7.setSelected(true);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(null, "Invalid kernel size loaded: " + this.s, "Error!", 2);
                return;
            }
        }
        n = streamTokenizer.nextToken();
        this.theta = streamTokenizer.nval;
        this.thetaText.setText(String.valueOf(this.theta));
        this.parameters.pack();
        this.parameters.setVisible(false);
    }

    public String saveParameters() {
        String string = new String();
        string = " " + this.s + " " + this.theta;
        return string;
    }

    void setParameters() {
        this.parameters = new JFrame(this.name);
        this.panel = new JPanel();
        this.p.setLayout(new BoxLayout(this.p, 1));
        JButton jButton = new JButton("Apply");
        this.panel.add(this.thetaLabel);
        this.panel.add(this.thetaText);
        this.size3.setSelected(true);
        this.group.add(this.size3);
        this.group.add(this.size4);
        this.group.add(this.size5);
        this.group.add(this.size6);
        this.group.add(this.size7);
        this.size3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gaussianSmooth.this.s = 3;
            }
        });
        this.size4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gaussianSmooth.this.s = 4;
            }
        });
        this.size5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gaussianSmooth.this.s = 5;
            }
        });
        this.size6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gaussianSmooth.this.s = 6;
            }
        });
        this.size7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gaussianSmooth.this.s = 7;
            }
        });
        this.p.add(this.kernelLabel);
        this.p.add(this.size3);
        this.p.add(this.size4);
        this.p.add(this.size5);
        this.p.add(this.size6);
        this.p.add(this.size7);
        this.panel.add(this.p);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gaussianSmooth.this.go();
            }
        });
        this.panel.add(jButton);
        this.parameters.getContentPane().add(this.panel);
        this.parameters.pack();
        this.parameters.setVisible(false);
    }

    public void go() {
        System.out.println(this.name);
        try {
            this.theta = Double.valueOf(this.thetaText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Invalid Theta Specified", "Error!", 2);
            return;
        }
        if (this.theta < 0.4 || this.theta > (double)((float)this.s / 6.0f)) {
            JOptionPane.showMessageDialog(null, "Invalid theta value. Must have 0.4 < theta < size/6", "Invalid Value", 2);
            return;
        }
        if (this.getInput1() != null) {
            System.out.println("Input Width 1 " + this.getInput1().getWidth());
            this.output1 = new image1DInt(this.input1.getWidth(), this.input1.getHeight(), imageConversions.pix2gs(GaussianSmooth.smooth_image(imageConversions.gs2pix(this.input1.getValues()), this.input1.getWidth(), this.input1.getHeight(), this.s, this.theta)));
            System.out.println("Output width " + this.getOutput1().getWidth());
            this.propagate();
        }
    }
}

