/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StreamTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class zeroCrossing
extends operator1DInt {
    JComboBox sizebox = new JComboBox();
    JLabel sizelabel = new JLabel("Select Kernel Size");
    JLabel thetalabel = new JLabel("Standard Deviation");
    JTextField thetaval = new JTextField(5);
    JComboBox limiterbox = new JComboBox();
    JLabel limiterLabel = new JLabel("Crossing Limiter");
    JTextField limitTextField = new JTextField("0", 3);
    JLabel limitLabel = new JLabel("Gradient Limit Value");
    JButton applyButton = new JButton("Apply");
    ZeroCrossing zeroCrossOp = new ZeroCrossing();
    static int number = 0;
    int kersize = 3;
    boolean limiter = true;
    String type = new String("ZeroCrossing");

    public zeroCrossing() {
    }

    public zeroCrossing(JPanel jPanel, linkData linkData2) {
        this.setName(this.type + "_" + ++number);
        this.setParameters();
        this.setType(this.type);
        this.setBox(jPanel, linkData2, 1, 1);
    }

    public String saveParameters() {
        String string = new String();
        string = " " + this.kersize + " " + this.thetaval.getText();
        string = this.limiter ? string + " true " : string + " false ";
        string = string + this.limitTextField.getText();
        return string;
    }

    public void loadParameters(StreamTokenizer streamTokenizer) throws IOException {
        int n = streamTokenizer.nextToken();
        this.kersize = (int)streamTokenizer.nval;
        switch (this.kersize) {
            case 3: {
                this.sizebox.setSelectedIndex(0);
                break;
            }
            case 4: {
                this.sizebox.setSelectedIndex(1);
                break;
            }
            case 5: {
                this.sizebox.setSelectedIndex(2);
                break;
            }
            case 6: {
                this.sizebox.setSelectedIndex(3);
                break;
            }
            case 7: {
                this.sizebox.setSelectedIndex(4);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(null, "Invalid kernel size loaded: " + this.kersize, "Error!", 2);
                return;
            }
        }
        n = streamTokenizer.nextToken();
        float f = (float)streamTokenizer.nval;
        this.thetaval.setText(String.valueOf(f));
        n = streamTokenizer.nextToken();
        String string = streamTokenizer.sval;
        if (string.equals("false")) {
            this.limiterbox.setSelectedIndex(0);
        } else {
            this.limiterbox.setSelectedIndex(1);
        }
        n = streamTokenizer.nextToken();
        float f2 = (float)streamTokenizer.nval;
        this.limitTextField.setText(String.valueOf(f2));
        this.parameters.pack();
        this.parameters.setVisible(false);
    }

    void setParameters() {
        this.parameters = new JFrame(this.name);
        this.panel = new JPanel();
        this.sizebox.addItem("3x3 Kernel");
        this.sizebox.addItem("4x4 Kernel");
        this.sizebox.addItem("5x5 Kernel");
        this.sizebox.addItem("6x6 Kernel");
        this.sizebox.addItem("7x7 Kernel");
        this.limiterbox.addItem("All Crossings");
        this.limiterbox.addItem("Gradient Limited Crossings");
        this.limitTextField.setEnabled(false);
        this.panel.add(this.sizelabel);
        this.panel.add(this.sizebox);
        this.panel.add(this.thetalabel);
        this.panel.add(this.thetaval);
        this.thetaval.setText("0.45");
        this.panel.add(this.limiterLabel);
        this.panel.add(this.limiterbox);
        this.panel.add(this.limitLabel);
        this.panel.add(this.limitTextField);
        this.panel.add(this.applyButton);
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    float f = Float.valueOf(zeroCrossing.this.thetaval.getText()).floatValue();
                    if ((double)f < 0.4 || f > (float)zeroCrossing.this.kersize / 6.0f) {
                        JOptionPane.showMessageDialog(null, "Theta value must be 0.4 < theta < kersize/6", "Error!", 2);
                        return;
                    }
                    zeroCrossing.this.go();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Invalid Parameters Specified", "Error!", 2);
                    return;
                }
            }
        });
        this.limiterbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                if (jComboBox.getSelectedItem().equals("All Crossings")) {
                    zeroCrossing.this.limitTextField.setEnabled(false);
                    zeroCrossing.this.limiter = false;
                } else {
                    zeroCrossing.this.limitTextField.setEnabled(true);
                    zeroCrossing.this.limiter = true;
                }
            }
        });
        this.sizebox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                if (jComboBox.getSelectedItem().equals("3x3 Kernel")) {
                    zeroCrossing.this.kersize = 3;
                }
                if (jComboBox.getSelectedItem().equals("4x4 Kernel")) {
                    zeroCrossing.this.kersize = 4;
                }
                if (jComboBox.getSelectedItem().equals("5x5 Kernel")) {
                    zeroCrossing.this.kersize = 5;
                }
                if (jComboBox.getSelectedItem().equals("6x6 Kernel")) {
                    zeroCrossing.this.kersize = 6;
                }
                if (jComboBox.getSelectedItem().equals("7x7 Kernel")) {
                    zeroCrossing.this.kersize = 7;
                }
            }
        });
        this.parameters.getContentPane().add(this.panel);
        this.parameters.pack();
        this.parameters.setVisible(false);
    }

    public void go() {
        System.out.println(this.name);
        if (this.getInput1() != null) {
            System.out.println("Input Width 1 " + this.getInput1().getWidth());
            try {
                this.output1 = new image1DInt(this.input1.getWidth(), this.input1.getHeight(), this.input1.getWidth() - 3, this.input1.getHeight() - 3, imageConversions.pix2gs(this.zeroCrossOp.apply_zeroCrossing(imageConversions.gs2pix(this.input1.getValues()), this.input1.getWidth(), this.input1.getHeight(), this.kersize, Float.valueOf(this.thetaval.getText()).floatValue(), this.limiter, new Float(this.limitTextField.getText()).intValue())));
                System.out.println("Output Width 1 " + this.getOutput1().getWidth());
                this.propagate();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, "Invalid Limit or Theta Parameter Specified", "Error!", 2);
                return;
            }
        }
    }
}

