/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class Convolution
extends Thread {
    public static double singlePixelConvolution(double[][] dArray, int n, int n2, double[][] dArray2, int n3, int n4) {
        double d = 0.0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                d += dArray[n + i][n2 + j] * dArray2[i][j];
            }
        }
        return d;
    }

    public static int applyConvolution(int[][] nArray, int n, int n2, double[][] dArray, int n3, int n4) {
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                n5 += (int)Math.round((double)nArray[n + i][n2 + j] * dArray[i][j]);
            }
        }
        return n5;
    }

    public static double[][] convolution2D(double[][] dArray, int n, int n2, double[][] dArray2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n - n3 + 1;
        int n8 = n2 - n4 + 1;
        double[][] dArray3 = new double[n7][n8];
        for (n6 = 0; n6 < n7; ++n6) {
            for (n5 = 0; n5 < n8; ++n5) {
                dArray3[n6][n5] = 0.0;
            }
        }
        for (n6 = 0; n6 < n7; ++n6) {
            for (n5 = 0; n5 < n8; ++n5) {
                dArray3[n6][n5] = Convolution.singlePixelConvolution(dArray, n6, n5, dArray2, n3, n4);
            }
        }
        return dArray3;
    }

    public static double[][] convolution2DPadded(double[][] dArray, int n, int n2, double[][] dArray2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n - n3 + 1;
        int n8 = n2 - n4 + 1;
        int n9 = n4 / 2;
        int n10 = n3 / 2;
        double[][] dArray3 = new double[n7][n8];
        dArray3 = Convolution.convolution2D(dArray, n, n2, dArray2, n3, n4);
        double[][] dArray4 = new double[n][n2];
        for (n6 = 0; n6 < n2; ++n6) {
            for (n5 = 0; n5 < n; ++n5) {
                dArray4[n5][n6] = 0.0;
            }
        }
        for (n6 = 0; n6 < n8; ++n6) {
            for (n5 = 0; n5 < n7; ++n5) {
                dArray4[n5 + n10][n6 + n9] = dArray3[n5][n6];
            }
        }
        return dArray4;
    }

    public static double[] convolutionDouble(double[][] dArray, int n, int n2, double[][] dArray2, int n3, int n4) {
        int n5 = n - n3 + 1;
        int n6 = n2 - n4 + 1;
        double[][] dArray3 = new double[n5][n6];
        dArray3 = Convolution.convolution2D(dArray, n, n2, dArray2, n3, n4);
        double[] dArray4 = new double[n5 * n6];
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                dArray4[i * n5 + j] = dArray3[j][i];
            }
        }
        return dArray4;
    }

    public static double[] convolutionDoublePadded(double[][] dArray, int n, int n2, double[][] dArray2, int n3, int n4) {
        double[][] dArray3 = new double[n][n2];
        dArray3 = Convolution.convolution2DPadded(dArray, n, n2, dArray2, n3, n4);
        double[] dArray4 = new double[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray4[i * n + j] = dArray3[j][i];
            }
        }
        return dArray4;
    }

    public static int[] doublesToValidPixels(double[] dArray) {
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            int n = dArray[i] > 255.0 ? 255 : (dArray[i] < 0.0 ? 0 : (int)Math.round(dArray[i]));
            nArray[i] = new Color(n, n, n).getRGB();
        }
        return nArray;
    }

    public double[][] convolutionType1(double[][] dArray, int n, int n2, double[][] dArray2, int n3, int n4, int n5) {
        double[][] dArray3 = (double[][])dArray.clone();
        double[][] dArray4 = (double[][])dArray.clone();
        for (int i = 0; i < n5; ++i) {
            int n6 = n - n3 + 1;
            int n7 = n2 - n4 + 1;
            dArray4 = new double[n6][n7];
            dArray4 = Convolution.convolution2D(dArray3, n, n2, dArray2, n3, n4);
            n = n6;
            n2 = n7;
            dArray3 = (double[][])dArray4.clone();
        }
        return dArray4;
    }

    public double[][] convolutionType2(double[][] dArray, int n, int n2, double[][] dArray2, int n3, int n4, int n5) {
        double[][] dArray3 = (double[][])dArray.clone();
        double[][] dArray4 = (double[][])dArray.clone();
        for (int i = 0; i < n5; ++i) {
            dArray4 = new double[n][n2];
            dArray4 = Convolution.convolution2DPadded(dArray3, n, n2, dArray2, n3, n4);
            dArray3 = (double[][])dArray4.clone();
        }
        return dArray4;
    }

    public static int[] convolution_image(int[] nArray, int n, int n2, double[][] dArray, int n3, int n4, double d, double d2) {
        int n5;
        double[][] dArray2 = new double[n][n2];
        double[] dArray3 = new double[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (n5 = 0; n5 < n; ++n5) {
                dArray2[n5][i] = new Color(nArray[i * n + n5]).getRed();
            }
        }
        dArray3 = Convolution.convolutionDoublePadded(dArray2, n, n2, dArray, n3, n4);
        int[] nArray2 = new int[n * n2];
        for (n5 = 0; n5 < nArray2.length; ++n5) {
            nArray2[n5] = (int)Math.round(dArray3[n5] * d + d2);
            if (nArray2[n5] > 255) {
                nArray2[n5] = 255;
            }
            if (nArray2[n5] < 0) {
                nArray2[n5] = 0;
            }
            int n6 = nArray2[n5];
            nArray2[n5] = new Color(n6, n6, n6).getRGB();
        }
        return nArray2;
    }
}

