/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class SCompassScreen
extends VisionApplet3 {
    Compass compass;
    TwoImages answer;
    boolean coloured = false;
    int kertype = 0;
    float scalevalue = 1.0f;
    int offsetvalue = 0;
    private ComboListener kernelcl = new ComboListener();
    private ComboListener pixcl = new ComboListener();
    private ButtonListener startbl = new ButtonListener();
    private ButtonListener abortbl = new ButtonListener();
    private WinListener colorwl = new WinListener();
    private ButtonListener colorbl = new ButtonListener();
    private JComboBox kernelchoice = new JComboBox();
    private JLabel kernellabel = new JLabel("Kernel Type");
    private JComboBox labelchoice = new JComboBox();
    private JLabel colourlabel = new JLabel("Labelling Type");
    private JButton startbutton = new JButton("Apply Compass");
    private JButton abortbutton = new JButton("Stop");
    private JTextField time_taken = new JTextField(20);
    private JLabel time = new JLabel("Time");
    private JLabel out2 = new JLabel("Pixel Labelling");
    private JLabel out3 = new JLabel("Edge Image");
    private JLabel offsetlabel = new JLabel("Offset");
    private JTextField offset = new JTextField(5);
    private JLabel scalelabel = new JLabel("Scale");
    private JTextField scale = new JTextField(5);
    private JFrame colorFrame = new JFrame("Color Assignment");
    private JLabel viewLabel = new JLabel("View Color Assignments");
    private JButton colorButton = new JButton("Color Map");
    private String picName = "colors.gif";
    private Icon pic;
    private JLabel picLabel;

    @Override
    public void add_extra() {
        this.compass = new Compass();
        try {
            URL uRL = new URL(this.getDocumentBase(), this.picName);
            this.pic = new ImageIcon(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(null, "Can't find " + this.picName, "Load Error", 2);
            return;
        }
        this.picLabel = new JLabel();
        this.picLabel.setIcon(this.pic);
        this.colorFrame.getContentPane().add(this.picLabel);
        this.bm.remove(this.output);
        this.bmc.gridx = 0;
        this.bmc.gridy = 0;
        this.bmlayout.setConstraints(this.out2, this.bmc);
        this.bm.add(this.out2);
        this.br.remove(this.output2);
        this.brc.gridx = 0;
        this.brc.gridy = 0;
        this.brlayout.setConstraints(this.out3, this.brc);
        this.br.add(this.out3);
        this.midc.weighty = 0.5;
        this.midc.gridx = 0;
        this.midc.gridy = 0;
        this.midlayout.setConstraints(this.kernellabel, this.midc);
        this.mid.add(this.kernellabel);
        this.midc.gridx = 1;
        this.midc.gridy = 0;
        this.midlayout.setConstraints(this.kernelchoice, this.midc);
        this.kernelchoice.addItem("Prewitt");
        this.kernelchoice.addItem("Sobel");
        this.kernelchoice.addItem("Kirsch");
        this.kernelchoice.addItem("Robinson");
        this.mid.add(this.kernelchoice);
        this.kernelchoice.addActionListener(this.kernelcl);
        this.midc.gridx = 0;
        this.midc.gridy = 1;
        this.midlayout.setConstraints(this.colourlabel, this.midc);
        this.mid.add(this.colourlabel);
        this.midc.gridx = 1;
        this.midc.gridy = 1;
        this.midlayout.setConstraints(this.labelchoice, this.midc);
        this.labelchoice.addItem("Greyscale");
        this.labelchoice.addItem("Color");
        this.mid.add(this.labelchoice);
        this.labelchoice.addActionListener(this.pixcl);
        this.midc.gridx = 0;
        this.midc.gridy = 2;
        this.midlayout.setConstraints(this.scalelabel, this.midc);
        this.mid.add(this.scalelabel);
        this.midc.gridx = 1;
        this.midc.gridy = 2;
        this.midlayout.setConstraints(this.scale, this.midc);
        this.mid.add(this.scale);
        this.scale.setText("1.0");
        this.midc.gridx = 0;
        this.midc.gridy = 3;
        this.midlayout.setConstraints(this.offsetlabel, this.midc);
        this.mid.add(this.offsetlabel);
        this.midc.gridx = 1;
        this.midc.gridy = 3;
        this.midlayout.setConstraints(this.offset, this.midc);
        this.mid.add(this.offset);
        this.offset.setText("0");
        this.midc.gridx = 0;
        this.midc.gridy = 4;
        this.midlayout.setConstraints(this.viewLabel, this.midc);
        this.mid.add(this.viewLabel);
        this.midc.gridx = 1;
        this.midc.gridy = 4;
        this.midlayout.setConstraints(this.colorButton, this.midc);
        this.mid.add(this.colorButton);
        this.colorButton.addActionListener(this.colorbl);
        this.midc.gridx = 0;
        this.midc.gridy = 5;
        this.midlayout.setConstraints(this.startbutton, this.midc);
        this.startbutton.setBackground(Color.green);
        this.mid.add(this.startbutton);
        this.startbutton.addActionListener(this.startbl);
        this.midc.gridx = -1;
        this.abortbutton.setBackground(Color.red);
        this.midlayout.setConstraints(this.abortbutton, this.midc);
        this.mid.add(this.abortbutton);
        this.abortbutton.addActionListener(this.abortbl);
        this.midc.gridx = 0;
        this.midc.gridy = 6;
        this.midlayout.setConstraints(this.time, this.midc);
        this.mid.add(this.time);
        this.midc.gridx = 1;
        this.midlayout.setConstraints(this.time_taken, this.midc);
        this.time_taken.setEditable(false);
        this.mid.add(this.time_taken);
        this.mid.repaint();
    }

    @Override
    public void set_src_image(int[] nArray, int n, int n2, String string) {
        this.set_src_image2(nArray, n, n2, string);
        this.compass = new Compass();
    }

    @Override
    public String getAppletInfo() {
        return "An applet for performing compass edge detection on an image. Written by Timothy Sharman";
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == SCompassScreen.this.startbutton) {
                try {
                    SCompassScreen.this.offsetvalue = Integer.valueOf(SCompassScreen.this.offset.getText());
                    SCompassScreen.this.scalevalue = Float.valueOf(SCompassScreen.this.scale.getText()).floatValue();
                    SCompassScreen.this.time_msec = System.currentTimeMillis();
                    SCompassScreen.this.answer = SCompassScreen.this.compass.apply_compass(SCompassScreen.this.src_1d, SCompassScreen.this.d_w, SCompassScreen.this.d_h, SCompassScreen.this.kertype, SCompassScreen.this.coloured, SCompassScreen.this.scalevalue, SCompassScreen.this.offsetvalue);
                    SCompassScreen.this.dest_1d2 = SCompassScreen.this.answer.image1;
                    SCompassScreen.this.dest_1d = SCompassScreen.this.answer.image2;
                    SCompassScreen.this.time_msec = System.currentTimeMillis() - SCompassScreen.this.time_msec;
                    SCompassScreen.this.time_taken.setText(new Long(SCompassScreen.this.time_msec).toString() + " msecs");
                    SCompassScreen.this.d_w -= 2;
                    SCompassScreen.this.d_h -= 2;
                    SCompassScreen.this.outsize1.setText(SCompassScreen.this.d_w + " x " + SCompassScreen.this.d_h);
                    SCompassScreen.this.outsize2.setText(SCompassScreen.this.d_w + " x " + SCompassScreen.this.d_h);
                    SCompassScreen.this.dest = SCompassScreen.this.createImage(new MemoryImageSource(SCompassScreen.this.d_w, SCompassScreen.this.d_h, SCompassScreen.this.dest_1d, 0, SCompassScreen.this.d_w));
                    SCompassScreen.this.dest2 = SCompassScreen.this.createImage(new MemoryImageSource(SCompassScreen.this.d_w, SCompassScreen.this.d_h, SCompassScreen.this.dest_1d2, 0, SCompassScreen.this.d_w));
                    SCompassScreen.this.d_w += 2;
                    SCompassScreen.this.d_h += 2;
                    SCompassScreen.this.dest_canvas.updateImage(SCompassScreen.this.dest);
                    SCompassScreen.this.dest_canvas2.updateImage(SCompassScreen.this.dest2);
                    VisionApplet3.PixelListener pixelListener = new VisionApplet3.PixelListener(SCompassScreen.this);
                    SCompassScreen.this.dest_canvas.addMouseMotionListener(pixelListener);
                    VisionApplet3.PixelListener pixelListener2 = new VisionApplet3.PixelListener(SCompassScreen.this);
                    SCompassScreen.this.dest_canvas2.addMouseMotionListener(pixelListener2);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Invalid parameters specified", "Error!", 2);
                }
                SCompassScreen.this.container.validate();
            } else if (jButton == SCompassScreen.this.abortbutton) {
                SCompassScreen.this.time_taken.setText("");
            } else if (jButton == SCompassScreen.this.colorButton) {
                SCompassScreen.this.colorFrame.pack();
                SCompassScreen.this.colorFrame.setVisible(true);
            }
        }
    }

    class ComboListener
    implements ActionListener {
        ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.getSelectedItem().equals("Prewitt")) {
                SCompassScreen.this.kertype = 0;
            }
            if (jComboBox.getSelectedItem().equals("Sobel")) {
                SCompassScreen.this.kertype = 1;
            }
            if (jComboBox.getSelectedItem().equals("Kirsch")) {
                SCompassScreen.this.kertype = 2;
            }
            if (jComboBox.getSelectedItem().equals("Robinson")) {
                SCompassScreen.this.kertype = 3;
            }
            if (jComboBox.getSelectedItem().equals("Greyscale")) {
                SCompassScreen.this.coloured = false;
            }
            if (jComboBox.getSelectedItem().equals("Color")) {
                SCompassScreen.this.coloured = true;
            }
        }
    }

    class WinListener
    extends WindowAdapter {
        WinListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            SCompassScreen.this.colorFrame.setVisible(false);
        }
    }
}

