/*
 * Decompiled with CFR 0.152.
 */
public class TwoDArray {
    public int width;
    public int height;
    public int size;
    public ComplexNumber[][] values;

    public TwoDArray() {
    }

    public TwoDArray(TwoDArray twoDArray) {
        this.width = twoDArray.width;
        this.height = twoDArray.height;
        this.size = twoDArray.size;
        this.values = new ComplexNumber[this.size][this.size];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                ComplexNumber complexNumber;
                this.values[j][i] = complexNumber = new ComplexNumber(twoDArray.values[j][i]);
            }
        }
    }

    public TwoDArray(int n, int n2) {
        this.width = n;
        this.height = n2;
        int n3 = 0;
        while (Math.pow(2.0, n3) < (double)Math.max(n, n2)) {
            ++n3;
        }
        this.size = (int)Math.pow(2.0, n3);
        this.values = new ComplexNumber[this.size][this.size];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.values[j][i] = new ComplexNumber(0.0, 0.0);
            }
        }
    }

    public TwoDArray(int n) {
        this.width = n;
        this.height = n;
        int n2 = 0;
        while (Math.pow(2.0, n2) < (double)n) {
            ++n2;
        }
        this.size = (int)Math.pow(2.0, n2);
        this.values = new ComplexNumber[this.size][this.size];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.values[j][i] = new ComplexNumber(0.0, 0.0);
            }
        }
    }

    public TwoDArray(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        this.width = n;
        this.height = n2;
        int n5 = 0;
        while (Math.pow(2.0, n5) < (double)Math.max(n, n2)) {
            ++n5;
        }
        this.size = (int)Math.pow(2.0, n5);
        this.values = new ComplexNumber[this.size][this.size];
        for (n4 = 0; n4 < this.size; ++n4) {
            for (n3 = 0; n3 < this.size; ++n3) {
                this.values[n3][n4] = new ComplexNumber(0.0, 0.0);
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                this.values[n3][n4] = new ComplexNumber(nArray[n3 + n4 * n], 0.0);
            }
        }
    }

    public TwoDArray(int[][] nArray, int n, int n2) {
        int n3;
        int n4;
        this.width = n;
        this.height = n2;
        int n5 = 0;
        while (Math.pow(2.0, n5) < (double)Math.max(n, n2)) {
            ++n5;
        }
        this.size = (int)Math.pow(2.0, n5);
        this.values = new ComplexNumber[this.size][this.size];
        for (n4 = 0; n4 < this.size; ++n4) {
            for (n3 = 0; n3 < this.size; ++n3) {
                this.values[n3][n4] = new ComplexNumber(0.0, 0.0);
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                this.values[n3][n4] = new ComplexNumber(nArray[n3][n4], 0.0);
            }
        }
    }

    public TwoDArray(ComplexNumber[][] complexNumberArray, int n, int n2) {
        int n3;
        int n4;
        this.width = n;
        this.height = n2;
        int n5 = 0;
        while (Math.pow(2.0, n5) < (double)Math.max(n, n2)) {
            ++n5;
        }
        this.size = (int)Math.pow(2.0, n5);
        this.values = new ComplexNumber[this.size][this.size];
        for (n4 = 0; n4 < this.size; ++n4) {
            for (n3 = 0; n3 < this.size; ++n3) {
                this.values[n3][n4] = new ComplexNumber(0.0, 0.0);
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                this.values[n3][n4] = new ComplexNumber(complexNumberArray[n3][n4]);
            }
        }
    }

    public ComplexNumber[] getColumn(int n) {
        ComplexNumber[] complexNumberArray = new ComplexNumber[this.size];
        for (int i = 0; i < this.size; ++i) {
            complexNumberArray[i] = new ComplexNumber(this.values[n][i]);
        }
        return complexNumberArray;
    }

    public void putColumn(int n, ComplexNumber[] complexNumberArray) {
        for (int i = 0; i < this.size; ++i) {
            this.values[n][i] = new ComplexNumber(complexNumberArray[i]);
        }
    }

    public void putRow(int n, ComplexNumber[] complexNumberArray) {
        for (int i = 0; i < this.size; ++i) {
            this.values[i][n] = new ComplexNumber(complexNumberArray[i]);
        }
    }

    public ComplexNumber[] getRow(int n) {
        ComplexNumber[] complexNumberArray = new ComplexNumber[this.size];
        for (int i = 0; i < this.size; ++i) {
            complexNumberArray[i] = new ComplexNumber(this.values[i][n]);
        }
        return complexNumberArray;
    }

    public double[][] DCToCentre(double[][] dArray) {
        double[][] dArray2 = new double[this.width][this.height];
        int n = this.width / 2;
        int n2 = this.height / 2;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int n3 = j + n;
                int n4 = i + n2;
                if (n3 >= this.width) {
                    n3 %= this.width;
                }
                if (n4 >= this.height) {
                    n4 %= this.height;
                }
                dArray2[j][i] = dArray[n3][n4];
            }
        }
        return dArray2;
    }

    public double[][] DCToTopLeft(double[][] dArray) {
        double[][] dArray2 = new double[this.width][this.height];
        int n = this.width / 2;
        int n2 = this.height / 2;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int n3 = j + n;
                int n4 = i + n;
                if (n3 >= this.width) {
                    n3 %= this.width;
                }
                if (n4 >= this.height) {
                    n4 %= this.height;
                }
                dArray2[j][i] = dArray[n3][n4];
            }
        }
        return dArray2;
    }

    public ComplexNumber[][] DCToTopLeft(ComplexNumber[][] complexNumberArray) {
        ComplexNumber[][] complexNumberArray2 = new ComplexNumber[this.width][this.height];
        int n = this.width / 2;
        int n2 = this.height / 2;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int n3 = j + n;
                int n4 = i + n;
                if (n3 >= this.width) {
                    n3 %= this.width;
                }
                if (n4 >= this.height) {
                    n4 %= this.height;
                }
                complexNumberArray2[j][i] = complexNumberArray[n3][n4];
            }
        }
        return complexNumberArray2;
    }

    public double[] DCToCentre(double[] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        double[][] dArray2 = new double[this.width][this.height];
        double[][] dArray3 = new double[this.width][this.height];
        double[] dArray4 = new double[this.width * this.height];
        for (n4 = 0; n4 < this.height; ++n4) {
            for (n3 = 0; n3 < this.width; ++n3) {
                dArray2[n3][n4] = dArray[n4 * this.width + n3];
            }
        }
        n4 = this.width / 2;
        n3 = this.height / 2;
        for (n2 = 0; n2 < this.height; ++n2) {
            for (n = 0; n < this.width; ++n) {
                int n5 = n + n4;
                int n6 = n2 + n3;
                if (n5 >= this.width) {
                    n5 %= this.width;
                }
                if (n6 >= this.height) {
                    n6 %= this.height;
                }
                dArray3[n][n2] = dArray2[n5][n6];
            }
        }
        for (n2 = 0; n2 < this.height; ++n2) {
            for (n = 0; n < this.width; ++n) {
                dArray4[n2 * this.width + n] = dArray3[n][n2];
            }
        }
        return dArray4;
    }

    public double[] getReal() {
        double[] dArray = new double[this.width * this.height];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                dArray[i * this.width + j] = this.values[j][i].real;
            }
        }
        return dArray;
    }

    public double[] getImaginary() {
        double[] dArray = new double[this.width * this.height];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                dArray[i * this.width + j] = this.values[j][i].imaginary;
            }
        }
        return dArray;
    }

    public double[] getMagnitude() {
        double[] dArray = new double[this.width * this.height];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                dArray[i * this.width + j] = this.values[j][i].magnitude();
            }
        }
        return dArray;
    }

    public double[] getPhase() {
        double[] dArray = new double[this.width * this.height];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                dArray[i * this.width + j] = this.values[j][i].phaseAngle();
            }
        }
        return dArray;
    }
}

