/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VisionApplet2
extends JApplet {
    public Container container = null;
    public Image src1;
    public Image src2;
    public Image dest;
    public ImageCanvas src1_canvas;
    public ImageCanvas src2_canvas;
    public ImageCanvas dest_canvas;
    public int[] src1_1d;
    public int[] src2_1d;
    public int[] dest_1d;
    public int i1_w;
    public int i1_h;
    public int i2_w;
    public int i2_h;
    public int d_w;
    public int d_h;
    private int actualx;
    private int actualy;
    public long time_msec;
    private GridBagLayout layout = new GridBagLayout();
    private GridBagLayout loadlayout = new GridBagLayout();
    public GridBagLayout midlayout = new GridBagLayout();
    public GridBagLayout outlayout = new GridBagLayout();
    private GridBagLayout brlayout = new GridBagLayout();
    private GridBagLayout bllayout = new GridBagLayout();
    private GridBagConstraints wholec = new GridBagConstraints();
    private GridBagConstraints loadc = new GridBagConstraints();
    public GridBagConstraints midc = new GridBagConstraints();
    public GridBagConstraints outc = new GridBagConstraints();
    private GridBagConstraints blc = new GridBagConstraints();
    private GridBagConstraints brc = new GridBagConstraints();
    private JPanel top = new JPanel();
    public JPanel mid = new JPanel();
    public JPanel out = new JPanel();
    private JPanel br = new JPanel();
    private JPanel bl = new JPanel();
    public JButton load_image = new JButton("Load image");
    public JButton load_image2 = new JButton("Load Image");
    public JTextField input = new JTextField(30);
    public JTextField input2 = new JTextField(30);
    private JLabel inputlab = new JLabel("Input 1");
    private JLabel inputlab2 = new JLabel("Input 2");
    public JLabel output = new JLabel("Output");
    public JLabel insize1 = new JLabel();
    public JLabel insize2 = new JLabel();
    public JLabel outsize = new JLabel();
    private JLabel blPosition = new JLabel("Point X:  Y: ");
    private JLabel brPosition = new JLabel("Point X:  Y: ");
    private JLabel outPosition = new JLabel("Point X:  Y: ");
    private JLabel blIntensity = new JLabel("Intensity: ");
    private JLabel brIntensity = new JLabel("Intensity: ");
    private JLabel outIntensity = new JLabel("Intensity: ");
    public PixelListener blpl = new PixelListener();
    public PixelListener brpl = new PixelListener();
    public PixelListener outpl = new PixelListener();
    private LoadListener ll = new LoadListener();
    private LoadListener ll2 = new LoadListener();
    public URL theURL;
    public String image_url = "scr1.gif";
    public String image_url2 = "scr2.gif";

    @Override
    public void init() {
        this.container = this.getContentPane();
        this.container.setLayout(this.layout);
        this.container.setBackground(Color.white);
        this.set_images();
        this.set_interface();
        this.add_extra();
        this.gui_add_image();
    }

    public void set_images() {
        Object object;
        try {
            object = new URL(this.getDocumentBase(), "images/" + this.image_url);
            this.src1 = this.getImage((URL)object);
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(null, "The default file is not present", "Load Error", 2);
            return;
        }
        try {
            object = new URL(this.getDocumentBase(), "images/" + this.image_url2);
            this.src2 = this.getImage((URL)object);
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(null, "The default file is not present", "Load Error", 2);
            return;
        }
        this.src1_canvas = new ImageCanvas(this.src1);
        this.src2_canvas = new ImageCanvas(this.src2);
        this.dest_canvas = new ImageCanvas(this.src1);
        this.i1_w = this.src1_canvas.getImageWidth();
        this.i1_h = this.src1_canvas.getImageHeight();
        this.i2_w = this.src2_canvas.getImageWidth();
        this.i2_h = this.src2_canvas.getImageHeight();
        this.src1_1d = new int[this.i1_w * this.i1_h];
        object = new PixelGrabber(this.src1, 0, 0, this.i1_w, this.i1_h, this.src1_1d, 0, this.i1_w);
        try {
            ((PixelGrabber)object).grabPixels();
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(null, "Unable to handle default file", "Load Error", 2);
            return;
        }
        if ((((PixelGrabber)object).status() & 0x80) != 0) {
            JOptionPane.showMessageDialog(null, "The default image file cannot be loaded", "Load Error", 2);
            return;
        }
        this.src2_1d = new int[this.i2_w * this.i2_h];
        PixelGrabber pixelGrabber = new PixelGrabber(this.src2, 0, 0, this.i2_w, this.i2_h, this.src2_1d, 0, this.i2_w);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(null, "Unable to handle default file", "Load Error", 2);
            return;
        }
        if ((pixelGrabber.status() & 0x80) != 0) {
            JOptionPane.showMessageDialog(null, "The default image file cannot be loaded", "Load Error", 2);
            return;
        }
        this.d_w = this.i1_w > this.i2_w ? this.i2_w : this.i1_w;
        this.d_h = this.i1_h > this.i2_h ? this.i2_h : this.i1_h;
        this.dest_1d = new int[this.d_w * this.d_h];
        for (int i = 0; i < this.dest_1d.length; ++i) {
            this.dest_1d[i] = this.src1_1d[i];
        }
    }

    public void set_interface() {
        PixelListener pixelListener = new PixelListener();
        PixelListener pixelListener2 = new PixelListener();
        PixelListener pixelListener3 = new PixelListener();
        this.src1_canvas.addMouseMotionListener(pixelListener);
        this.src2_canvas.addMouseMotionListener(pixelListener2);
        this.dest_canvas.addMouseMotionListener(pixelListener3);
        this.top.setLayout(this.loadlayout);
        this.top.setBackground(Color.white);
        this.loadc.fill = 1;
        this.loadc.gridx = 0;
        this.loadc.gridy = 0;
        this.loadlayout.setConstraints(this.load_image, this.loadc);
        this.top.add(this.load_image);
        this.loadc.gridwidth = 0;
        this.loadc.gridx = 1;
        this.loadc.gridy = 0;
        this.loadlayout.setConstraints(this.input, this.loadc);
        this.top.add(this.input);
        this.input.setText(this.image_url);
        this.load_image.addActionListener(this.ll);
        this.loadc.anchor = 10;
        this.loadc.gridwidth = 1;
        this.loadc.fill = 1;
        this.loadc.gridx = 0;
        this.loadc.gridy = 1;
        this.loadlayout.setConstraints(this.load_image2, this.loadc);
        this.top.add(this.load_image2);
        this.loadc.gridwidth = 0;
        this.loadc.gridx = 1;
        this.loadc.gridy = 1;
        this.loadlayout.setConstraints(this.input2, this.loadc);
        this.top.add(this.input2);
        this.input2.setText(this.image_url2);
        this.load_image2.addActionListener(this.ll2);
        this.mid.setLayout(this.midlayout);
        this.mid.setBackground(Color.white);
        this.out.setLayout(this.outlayout);
        this.out.setBackground(Color.white);
        this.outlayout.setConstraints(this.output, this.outc);
        this.out.add(this.output);
        this.outc.gridx = 0;
        this.outc.gridy = 2;
        this.outlayout.setConstraints(this.outsize, this.outc);
        this.outsize.setText(this.d_w + " x " + this.d_h);
        this.out.add(this.outsize);
        this.outc.gridx = 0;
        this.outc.gridy = 3;
        this.outlayout.setConstraints(this.outPosition, this.outc);
        this.out.add(this.outPosition);
        this.outc.gridx = 0;
        this.outc.gridy = 4;
        this.outlayout.setConstraints(this.outIntensity, this.outc);
        this.out.add(this.outIntensity);
        this.br.setLayout(this.brlayout);
        this.br.setBackground(Color.white);
        this.brc.gridx = 0;
        this.brc.gridy = 0;
        this.brlayout.setConstraints(this.inputlab2, this.brc);
        this.br.add(this.inputlab2);
        this.brc.gridx = 0;
        this.brc.gridy = 2;
        this.brlayout.setConstraints(this.insize2, this.brc);
        this.insize2.setText(this.i2_w + " x " + this.i2_h);
        this.br.add(this.insize2);
        this.brc.gridx = 0;
        this.brc.gridy = 3;
        this.brlayout.setConstraints(this.brPosition, this.brc);
        this.br.add(this.brPosition);
        this.brc.gridx = 0;
        this.brc.gridy = 4;
        this.brlayout.setConstraints(this.brIntensity, this.brc);
        this.br.add(this.brIntensity);
        this.bl.setLayout(this.bllayout);
        this.bl.setBackground(Color.white);
        this.blc.gridx = 0;
        this.blc.gridy = 0;
        this.bllayout.setConstraints(this.inputlab, this.blc);
        this.bl.add(this.inputlab);
        this.blc.gridx = 0;
        this.blc.gridy = 2;
        this.bllayout.setConstraints(this.insize1, this.blc);
        this.insize1.setText(this.i1_w + " x " + this.i1_h);
        this.bl.add(this.insize1);
        this.blc.gridx = 0;
        this.blc.gridy = 3;
        this.bllayout.setConstraints(this.blPosition, this.blc);
        this.bl.add(this.blPosition);
        this.blc.gridx = 0;
        this.blc.gridy = 4;
        this.bllayout.setConstraints(this.blIntensity, this.blc);
        this.bl.add(this.blIntensity);
        this.wholec.gridx = 0;
        this.wholec.gridy = 0;
        this.wholec.gridwidth = 3;
        this.wholec.fill = 1;
        this.wholec.weightx = 0.3;
        this.wholec.weighty = 0.2;
        this.layout.setConstraints(this.top, this.wholec);
        this.container.add(this.top);
        this.wholec.gridwidth = 3;
        this.wholec.gridx = 0;
        this.wholec.gridy = 1;
        this.layout.setConstraints(this.mid, this.wholec);
        this.container.add(this.mid);
        this.wholec.gridx = 0;
        this.wholec.gridy = 2;
        this.wholec.gridwidth = 1;
        this.layout.setConstraints(this.bl, this.wholec);
        this.container.add(this.bl);
        this.wholec.gridx = 1;
        this.wholec.gridy = 2;
        this.layout.setConstraints(this.br, this.wholec);
        this.container.add(this.br);
        this.wholec.anchor = 10;
        this.wholec.fill = 0;
        this.wholec.gridx = 2;
        this.wholec.gridy = 2;
        this.layout.setConstraints(this.out, this.wholec);
        this.container.add(this.out);
    }

    public void add_extra() {
    }

    private void gui_add_image() {
        this.blc.gridx = 0;
        this.blc.gridy = 1;
        this.bllayout.setConstraints(this.src1_canvas, this.blc);
        this.bl.add(this.src1_canvas);
        this.brc.gridx = 0;
        this.brc.gridy = 1;
        this.brlayout.setConstraints(this.src2_canvas, this.brc);
        this.br.add(this.src2_canvas);
        this.outc.gridx = 0;
        this.outc.gridy = 1;
        this.outlayout.setConstraints(this.dest_canvas, this.outc);
        this.out.add(this.dest_canvas);
    }

    public void set_src1_image2(int[] nArray, int n, int n2, String string) {
        this.i1_w = n;
        this.i1_h = n2;
        this.src1_1d = new int[this.i1_w * this.i1_h];
        this.src1_1d = nArray;
        this.src1 = this.createImage(new MemoryImageSource(this.i1_w, this.i1_h, this.src1_1d, 0, this.i1_w));
        this.src1_canvas.updateImage(this.src1);
        this.insize1.setText(this.i1_w + " x " + this.i1_h);
        this.d_w = this.i1_w > this.i2_w ? this.i2_w : this.i1_w;
        this.d_h = this.i1_h > this.i2_h ? this.i2_h : this.i1_h;
        this.dest_1d = new int[this.d_w * this.d_h];
        this.dest_1d = nArray;
        this.dest = this.createImage(new MemoryImageSource(this.i1_w, this.i1_h, this.dest_1d, 0, this.i1_w));
        this.dest_canvas.updateImage(this.dest);
        this.outsize.setText(this.i1_w + " x " + this.i1_h);
        PixelListener pixelListener = new PixelListener();
        PixelListener pixelListener2 = new PixelListener();
        this.src1_canvas.addMouseMotionListener(pixelListener);
        this.dest_canvas.addMouseMotionListener(pixelListener2);
        this.blPosition.setText("Point X:  Y: ");
        this.outPosition.setText("Point X:  Y: ");
        this.blIntensity.setText("Intensity: ");
        this.outIntensity.setText("Intensity: ");
    }

    public void set_src1_image(int[] nArray, int n, int n2, String string) {
        this.set_src1_image2(nArray, n, n2, string);
    }

    public void set_src2_image2(int[] nArray, int n, int n2, String string) {
        this.i2_w = n;
        this.i2_h = n2;
        this.src2_1d = new int[this.i2_w * this.i2_h];
        this.src2_1d = nArray;
        this.src2 = this.createImage(new MemoryImageSource(this.i2_w, this.i2_h, this.src2_1d, 0, this.i2_w));
        this.src2_canvas.updateImage(this.src2);
        this.insize2.setText(this.i2_w + " x " + this.i2_h);
        this.d_w = this.i1_w > this.i2_w ? this.i2_w : this.i1_w;
        this.d_h = this.i1_h > this.i2_h ? this.i2_h : this.i1_h;
        PixelListener pixelListener = new PixelListener();
        this.src2_canvas.addMouseMotionListener(pixelListener);
        this.brPosition.setText("Point X:  Y: ");
        this.brIntensity.setText("Intensity: ");
    }

    public void set_src2_image(int[] nArray, int n, int n2, String string) {
        this.set_src2_image2(nArray, n, n2, string);
    }

    public void apply_send_image(int n) {
        MediaTracker mediaTracker = new MediaTracker(this);
        Image image = this.getImage(this.theURL);
        mediaTracker.addImage(image, 0);
        if (n == 1) {
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
                return;
            }
            if (mediaTracker.statusID(0, false) == 4) {
                JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
                return;
            }
            ImageCanvas imageCanvas = new ImageCanvas(image);
            this.i1_w = imageCanvas.getImageWidth();
            this.i1_h = imageCanvas.getImageHeight();
            int[] nArray = new int[this.i1_w * this.i1_h];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.i1_w, this.i1_h, nArray, 0, this.i1_w);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
                return;
            }
            if ((pixelGrabber.status() & 0x80) != 0) {
                JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
                return;
            }
            this.set_src1_image(nArray, this.i1_w, this.i1_h, this.image_url);
        } else if (n == 2) {
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
                return;
            }
            if (mediaTracker.statusID(0, false) == 4) {
                JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
                return;
            }
            ImageCanvas imageCanvas = new ImageCanvas(image);
            this.i2_w = imageCanvas.getImageWidth();
            this.i2_h = imageCanvas.getImageHeight();
            int[] nArray = new int[this.i2_w * this.i2_h];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.i2_w, this.i2_h, nArray, 0, this.i2_w);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
                return;
            }
            if ((pixelGrabber.status() & 0x80) != 0) {
                JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
                return;
            }
            this.set_src2_image(nArray, this.i2_w, this.i2_h, this.image_url2);
        }
    }

    @Override
    public String getAppletInfo() {
        return "An applet for running image processing operators on. Written by Timothy Sharman";
    }

    class LoadListener
    implements ActionListener {
        LoadListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == VisionApplet2.this.load_image) {
                VisionApplet2.this.image_url = VisionApplet2.this.input.getText();
                try {
                    VisionApplet2.this.theURL = new URL(VisionApplet2.this.image_url);
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        VisionApplet2.this.theURL = new URL(VisionApplet2.this.getDocumentBase(), "images/" + VisionApplet2.this.image_url);
                    }
                    catch (MalformedURLException malformedURLException2) {
                        JOptionPane.showMessageDialog(null, "File not found", "Load Error", 2);
                        return;
                    }
                }
                String string = VisionApplet2.this.theURL.getFile();
                if (!string.endsWith("jpg") && !string.endsWith("gif")) {
                    JOptionPane.showMessageDialog(null, "Invalid file extension. Use .gif or .jpg", "Load Error", 2);
                    return;
                }
                VisionApplet2.this.apply_send_image(1);
            } else if (actionEvent.getSource() == VisionApplet2.this.load_image2) {
                VisionApplet2.this.image_url2 = VisionApplet2.this.input2.getText();
                try {
                    VisionApplet2.this.theURL = new URL(VisionApplet2.this.image_url2);
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        VisionApplet2.this.theURL = new URL(VisionApplet2.this.getDocumentBase(), "images/" + VisionApplet2.this.image_url2);
                    }
                    catch (MalformedURLException malformedURLException3) {
                        JOptionPane.showMessageDialog(null, "File not found", "Load Error", 2);
                        return;
                    }
                }
                String string = VisionApplet2.this.theURL.getFile();
                if (!string.endsWith("jpg") && !string.endsWith("gif")) {
                    JOptionPane.showMessageDialog(null, "Invalid file extension. Use .gif or .jpg", "Load Error", 2);
                    return;
                }
                VisionApplet2.this.apply_send_image(2);
            }
        }
    }

    public class PixelListener
    extends MouseMotionAdapter {
        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            ImageCanvas imageCanvas = (ImageCanvas)mouseEvent.getSource();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            int n4 = 0;
            int n5 = imageCanvas.getImageWidth();
            int n6 = imageCanvas.getImageHeight();
            try {
                if (n5 >= 256 || n6 >= 256) {
                    float f;
                    if (n5 > n6) {
                        f = (float)n5 / (float)n6;
                        n3 = 256;
                        n4 = (int)(256.0f / f);
                        VisionApplet2.this.actualx = (int)((float)n5 / (float)n3 * (float)n);
                        VisionApplet2.this.actualy = (int)((float)n6 / (float)n4 * (float)n2);
                    } else if (n6 > n5) {
                        f = (float)n6 / (float)n5;
                        n3 = n5;
                        n4 = 256;
                        n3 = (int)(256.0f / f);
                        VisionApplet2.this.actualx = (int)((float)n5 / (float)n3 * (float)n);
                        VisionApplet2.this.actualy = (int)((float)n6 / (float)n4 * (float)n2);
                    } else {
                        VisionApplet2.this.actualx = (int)((float)n5 / 256.0f * (float)n);
                        VisionApplet2.this.actualy = (int)((float)n6 / 256.0f * (float)n2);
                    }
                } else {
                    VisionApplet2.this.actualx = n;
                    VisionApplet2.this.actualy = n2;
                }
                if (VisionApplet2.this.actualx >= 0 && VisionApplet2.this.actualy >= 0) {
                    if (VisionApplet2.this.actualx > n5 - 1) {
                        VisionApplet2.this.actualx = n5 - 1;
                    }
                    if (VisionApplet2.this.actualy > n6 - 1) {
                        VisionApplet2.this.actualy = n6 - 1;
                    }
                    if (imageCanvas == VisionApplet2.this.src1_canvas) {
                        int n7 = VisionApplet2.this.src1_1d[VisionApplet2.this.actualx + VisionApplet2.this.actualy * n5] & 0xFF;
                        VisionApplet2.this.blPosition.setText("Point X:" + VisionApplet2.this.actualx + "  Y:" + VisionApplet2.this.actualy);
                        VisionApplet2.this.blIntensity.setText("Intensity:" + n7);
                    }
                    if (imageCanvas == VisionApplet2.this.src2_canvas) {
                        int n8 = VisionApplet2.this.src2_1d[VisionApplet2.this.actualx + VisionApplet2.this.actualy * n5] & 0xFF;
                        VisionApplet2.this.brPosition.setText("Point X:" + VisionApplet2.this.actualx + "  Y:" + VisionApplet2.this.actualy);
                        VisionApplet2.this.brIntensity.setText("Intensity:" + n8);
                    }
                    if (imageCanvas == VisionApplet2.this.dest_canvas) {
                        int n9 = VisionApplet2.this.dest_1d[VisionApplet2.this.actualx + VisionApplet2.this.actualy * n5] & 0xFF;
                        VisionApplet2.this.outPosition.setText("Point X:" + VisionApplet2.this.actualx + "  Y:" + VisionApplet2.this.actualy);
                        VisionApplet2.this.outIntensity.setText("Intensity:" + n9);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }
}

