/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.MouseInputAdapter;

public class SScaleScreen
extends VisionApplet1 {
    public ScaleImageCanvas src_canvas;
    private int scalefactor;
    boolean interpolate;
    boolean shrink;
    private int sample_x;
    private int sample_y;
    Scale scale;
    Point point = null;
    private ComboListener clmethod = new ComboListener();
    private ComboListener cldirection = new ComboListener();
    private ComboListener clscale = new ComboListener();
    private ButtonListener startbl = new ButtonListener();
    private ButtonListener abortbl = new ButtonListener();
    private JLabel timelabel = new JLabel("Elapsed Time");
    private JButton startbutton = new JButton("Scale");
    private JButton abortbutton = new JButton("Stop");
    private JLabel time = new JLabel("Time");
    private JTextField time_taken = new JTextField(20);
    private JComboBox methodtoggle = new JComboBox();
    private JComboBox directiontoggle = new JComboBox();
    private JComboBox scaletoggle = new JComboBox();
    private JLabel method = new JLabel("Method :");
    private JLabel direction = new JLabel("Direction :");
    private JLabel scalelab = new JLabel("Scale :");

    @Override
    public void add_extra() {
        this.sample_x = 0;
        this.sample_y = 0;
        this.scalefactor = 2;
        this.interpolate = false;
        this.shrink = true;
        this.scale = new Scale();
        this.midc.weighty = 0.5;
        this.midc.gridx = 0;
        this.midc.gridy = 0;
        this.midlayout.setConstraints(this.method, this.midc);
        this.mid.add(this.method);
        this.midc.gridx = 1;
        this.midc.gridy = 0;
        this.midlayout.setConstraints(this.direction, this.midc);
        this.mid.add(this.direction);
        this.midc.gridx = 2;
        this.midc.gridy = 0;
        this.midlayout.setConstraints(this.scalelab, this.midc);
        this.mid.add(this.scalelab);
        this.midc.gridx = 0;
        this.midc.gridy = 1;
        this.methodtoggle.addItem("Selection/Replication");
        this.methodtoggle.addItem("Interpolation");
        this.midlayout.setConstraints(this.methodtoggle, this.midc);
        this.mid.add(this.methodtoggle);
        this.methodtoggle.addActionListener(this.clmethod);
        this.midc.gridx = 1;
        this.midc.gridy = 1;
        this.directiontoggle.addItem("Shrink");
        this.directiontoggle.addItem("Expand");
        this.midlayout.setConstraints(this.directiontoggle, this.midc);
        this.mid.add(this.directiontoggle);
        this.directiontoggle.addActionListener(this.cldirection);
        this.midc.gridx = 2;
        this.midc.gridy = 1;
        this.scaletoggle.addItem("2");
        this.scaletoggle.addItem("3");
        this.scaletoggle.addItem("4");
        this.midlayout.setConstraints(this.scaletoggle, this.midc);
        this.mid.add(this.scaletoggle);
        this.scaletoggle.addActionListener(this.clscale);
        this.midc.gridx = 0;
        this.midc.gridy = 2;
        this.midlayout.setConstraints(this.startbutton, this.midc);
        this.startbutton.setBackground(Color.green);
        this.mid.add(this.startbutton);
        this.startbutton.addActionListener(this.startbl);
        this.midc.gridx = -1;
        this.abortbutton.setBackground(Color.red);
        this.midlayout.setConstraints(this.abortbutton, this.midc);
        this.mid.add(this.abortbutton);
        this.abortbutton.addActionListener(this.abortbl);
        this.midc.gridx = 0;
        this.midc.gridy = 3;
        this.midlayout.setConstraints(this.time, this.midc);
        this.mid.add(this.time);
        this.midc.gridx = 1;
        this.midc.gridy = 3;
        this.midlayout.setConstraints(this.time_taken, this.midc);
        this.time_taken.setEditable(false);
        this.mid.add(this.time_taken);
        this.mid.repaint();
        this.container.validate();
    }

    public int[] get_rect(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int[] nArray2 = new int[n4 * n5];
        int n6 = 0;
        for (int i = n3; i < n3 + n5; ++i) {
            for (int j = n2; j < n2 + n4; ++j) {
                nArray2[n6++] = nArray[i * n + j];
            }
        }
        return nArray2;
    }

    @Override
    public void set_src_image(int[] nArray, int n, int n2, String string) {
        this.i_w = n;
        this.i_h = n2;
        this.src_1d = new int[this.i_w * this.i_h];
        this.src_1d = nArray;
        this.src = this.createImage(new MemoryImageSource(this.i_w, this.i_h, this.src_1d, 0, this.i_w));
        if (this.src_canvas != null) {
            this.bl.remove(this.src_canvas);
        }
        this.src_canvas = new ScaleImageCanvas(this.src);
        this.blc.gridx = 0;
        this.blc.gridy = 1;
        this.bllayout.setConstraints(this.src_canvas, this.blc);
        this.bl.add(this.src_canvas);
        this.bl.validate();
        this.bl.repaint();
        this.insize.setText(this.i_w + " x " + this.i_h);
        MyMouseListener myMouseListener = new MyMouseListener();
        this.src_canvas.addMouseListener(myMouseListener);
        this.src_canvas.addMouseMotionListener(myMouseListener);
        this.blPosition.setText("Point X:  Y: ");
        this.blIntensity.setText("Intensity: ");
        if (this.shrink) {
            this.src_canvas.width = 0;
            this.src_canvas.height = 0;
            this.src_canvas.paint(this.src_canvas.getGraphics());
        }
        this.scale = new Scale();
        this.d_w = this.i_w;
        this.d_h = this.i_h;
        this.dest_1d = new int[this.i_w * this.i_h];
        this.dest_1d = nArray;
        this.dest = this.createImage(new MemoryImageSource(this.d_w, this.d_h, this.dest_1d, 0, this.d_w));
        if (this.dest_canvas != null) {
            this.br.remove(this.dest_canvas);
        }
        this.dest_canvas = new ImageCanvas(this.dest);
        VisionApplet1.PixelListener pixelListener = new VisionApplet1.PixelListener(this);
        this.dest_canvas.addMouseMotionListener(pixelListener);
        this.brPosition.setText("Point X:  Y: ");
        this.brIntensity.setText("Intensity: ");
        this.brc.gridx = 0;
        this.brc.gridy = 1;
        this.brlayout.setConstraints(this.dest_canvas, this.brc);
        this.br.add(this.dest_canvas);
        this.outsize.setText(this.d_w + " x " + this.d_h);
        this.container.validate();
        this.container.repaint();
    }

    @Override
    public void set_image() {
        Object object;
        String string = "brg1.gif";
        try {
            object = new URL(this.getDocumentBase(), "images/" + string);
            this.src = this.getImage((URL)object);
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(null, "The default file is not present", "Load Error", 2);
            return;
        }
        this.src_canvas = new ScaleImageCanvas(this.src);
        this.dest_canvas = new ImageCanvas(this.src);
        this.i_w = this.src_canvas.getImageWidth();
        this.i_h = this.src_canvas.getImageHeight();
        this.src_1d = new int[this.i_w * this.i_h];
        object = new PixelGrabber(this.src, 0, 0, this.i_w, this.i_h, this.src_1d, 0, this.i_w);
        try {
            ((PixelGrabber)object).grabPixels();
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(null, "Unable to handle default file", "Load Error", 2);
            return;
        }
        if ((((PixelGrabber)object).status() & 0x80) != 0) {
            JOptionPane.showMessageDialog(null, "The default file image cannot be loaded", "Load Error", 2);
            return;
        }
        this.d_w = this.i_w;
        this.d_h = this.i_h;
        this.dest_1d = new int[this.d_w * this.d_h];
        for (int i = 0; i < this.dest_1d.length; ++i) {
            this.dest_1d[i] = this.src_1d[i];
        }
    }

    @Override
    public void gui_add_image() {
        this.blc.gridx = 0;
        this.blc.gridy = 1;
        this.bllayout.setConstraints(this.src_canvas, this.blc);
        this.bl.add(this.src_canvas);
        MyMouseListener myMouseListener = new MyMouseListener();
        this.src_canvas.addMouseListener(myMouseListener);
        this.src_canvas.addMouseMotionListener(myMouseListener);
        this.brc.gridx = 0;
        this.brc.gridy = 1;
        this.brlayout.setConstraints(this.dest_canvas, this.brc);
        this.br.add(this.dest_canvas);
        this.dest_canvas.addMouseMotionListener(this.brpl);
        this.container.doLayout();
        this.container.repaint();
    }

    @Override
    public void apply_send_image() {
        MediaTracker mediaTracker = new MediaTracker(this);
        Image image = this.getImage(this.theURL);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        if (mediaTracker.statusID(0, false) == 4) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        ScaleImageCanvas scaleImageCanvas = new ScaleImageCanvas(image);
        int n = scaleImageCanvas.getImageWidth();
        int n2 = scaleImageCanvas.getImageHeight();
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        if ((pixelGrabber.status() & 0x80) != 0) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        this.set_src_image(nArray, n, n2, this.image_url);
    }

    @Override
    public String getAppletInfo() {
        return "An applet for applying scaling to an image :part of the code.iface package. Written by Craig Strachan, heavily based on code by Judy Robertson, SELLIC OnLine, Timothy Sharman";
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == SScaleScreen.this.startbutton) {
                SScaleScreen.this.time_msec = System.currentTimeMillis();
                SScaleScreen.this.dest_1d = SScaleScreen.this.shrink ? (SScaleScreen.this.interpolate ? SScaleScreen.this.scale.shrink_average(SScaleScreen.this.src_1d, SScaleScreen.this.i_w, SScaleScreen.this.i_h, SScaleScreen.this.scalefactor) : SScaleScreen.this.scale.shrink_sample(SScaleScreen.this.src_1d, SScaleScreen.this.i_w, SScaleScreen.this.i_h, SScaleScreen.this.scalefactor)) : (!SScaleScreen.this.interpolate ? SScaleScreen.this.scale.grow_replicate(SScaleScreen.this.get_rect(SScaleScreen.this.src_1d, SScaleScreen.this.src_canvas.getImageWidth(), SScaleScreen.this.src_canvas.x, SScaleScreen.this.src_canvas.y, SScaleScreen.this.src_canvas.width, SScaleScreen.this.src_canvas.height), SScaleScreen.this.src_canvas.width, SScaleScreen.this.src_canvas.height, SScaleScreen.this.scalefactor) : SScaleScreen.this.scale.grow_interpolate(SScaleScreen.this.get_rect(SScaleScreen.this.src_1d, SScaleScreen.this.src_canvas.getImageWidth(), SScaleScreen.this.src_canvas.x, SScaleScreen.this.src_canvas.y, SScaleScreen.this.src_canvas.width, SScaleScreen.this.src_canvas.height), SScaleScreen.this.src_canvas.width, SScaleScreen.this.src_canvas.height, SScaleScreen.this.scalefactor));
                SScaleScreen.this.time_msec = System.currentTimeMillis() - SScaleScreen.this.time_msec;
                SScaleScreen.this.time_taken.setText(new Long(SScaleScreen.this.time_msec).toString() + " msecs");
                if (SScaleScreen.this.shrink) {
                    SScaleScreen.this.dest = SScaleScreen.this.createImage(new MemoryImageSource(SScaleScreen.this.i_w / SScaleScreen.this.scalefactor, SScaleScreen.this.i_h / SScaleScreen.this.scalefactor, SScaleScreen.this.dest_1d, 0, SScaleScreen.this.i_w / SScaleScreen.this.scalefactor));
                    SScaleScreen.this.d_w = SScaleScreen.this.i_w / SScaleScreen.this.scalefactor;
                    SScaleScreen.this.d_h = SScaleScreen.this.i_h / SScaleScreen.this.scalefactor;
                    SScaleScreen.this.outsize.setText(SScaleScreen.this.d_w + " x " + SScaleScreen.this.d_h);
                } else {
                    SScaleScreen.this.dest = SScaleScreen.this.createImage(new MemoryImageSource(SScaleScreen.this.src_canvas.width * SScaleScreen.this.scalefactor, SScaleScreen.this.src_canvas.height * SScaleScreen.this.scalefactor, SScaleScreen.this.dest_1d, 0, SScaleScreen.this.src_canvas.width * SScaleScreen.this.scalefactor));
                    SScaleScreen.this.d_w = SScaleScreen.this.src_canvas.width * SScaleScreen.this.scalefactor;
                    SScaleScreen.this.d_h = SScaleScreen.this.src_canvas.height * SScaleScreen.this.scalefactor;
                    SScaleScreen.this.outsize.setText(SScaleScreen.this.d_w + " x " + SScaleScreen.this.d_h);
                }
                if (SScaleScreen.this.dest_canvas != null) {
                    SScaleScreen.this.br.remove(SScaleScreen.this.dest_canvas);
                }
                SScaleScreen.this.dest_canvas = new ImageCanvas(SScaleScreen.this.dest);
                VisionApplet1.PixelListener pixelListener = new VisionApplet1.PixelListener(SScaleScreen.this);
                SScaleScreen.this.dest_canvas.addMouseMotionListener(pixelListener);
                SScaleScreen.this.brc.gridx = 0;
                SScaleScreen.this.brc.gridy = 1;
                SScaleScreen.this.brlayout.setConstraints(SScaleScreen.this.dest_canvas, SScaleScreen.this.brc);
                SScaleScreen.this.br.add(SScaleScreen.this.dest_canvas);
                SScaleScreen.this.br.validate();
                SScaleScreen.this.br.doLayout();
                SScaleScreen.this.container.validate();
            } else if (jButton == SScaleScreen.this.abortbutton) {
                SScaleScreen.this.time_taken.setText("");
            }
        }
    }

    class ComboListener
    implements ActionListener {
        ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.getSelectedItem().equals("Interpolation")) {
                SScaleScreen.this.interpolate = true;
            } else if (jComboBox.getSelectedItem().equals("Selection/Replication")) {
                SScaleScreen.this.interpolate = false;
            } else if (jComboBox.getSelectedItem().equals("Expand")) {
                SScaleScreen.this.src_canvas.x_Y(1, 1);
                SScaleScreen.this.shrink = false;
                SScaleScreen.this.src_canvas.width = SScaleScreen.this.i_w / SScaleScreen.this.scalefactor;
                SScaleScreen.this.src_canvas.height = SScaleScreen.this.i_h / SScaleScreen.this.scalefactor;
                SScaleScreen.this.src_canvas.paint(SScaleScreen.this.src_canvas.getGraphics());
            } else if (jComboBox.getSelectedItem().equals("Shrink")) {
                SScaleScreen.this.src_canvas.x_Y(1, 1);
                SScaleScreen.this.shrink = true;
                SScaleScreen.this.src_canvas.width = 0;
                SScaleScreen.this.src_canvas.height = 0;
                SScaleScreen.this.src_canvas.paint(SScaleScreen.this.src_canvas.getGraphics());
            } else if (jComboBox == SScaleScreen.this.scaletoggle) {
                if (SScaleScreen.this.scaletoggle.getSelectedItem().equals("2")) {
                    SScaleScreen.this.scalefactor = 2;
                } else if (SScaleScreen.this.scaletoggle.getSelectedItem().equals("3")) {
                    SScaleScreen.this.scalefactor = 3;
                } else {
                    SScaleScreen.this.scalefactor = 4;
                }
                if (SScaleScreen.this.directiontoggle.getSelectedItem().equals("Expand")) {
                    SScaleScreen.this.src_canvas.width = SScaleScreen.this.i_w / SScaleScreen.this.scalefactor;
                    if (SScaleScreen.this.src_canvas.x + SScaleScreen.this.src_canvas.width > SScaleScreen.this.src_canvas.getImageWidth()) {
                        SScaleScreen.this.src_canvas.x = SScaleScreen.this.src_canvas.getImageWidth() - SScaleScreen.this.src_canvas.width;
                    }
                    SScaleScreen.this.src_canvas.height = SScaleScreen.this.i_h / SScaleScreen.this.scalefactor;
                    if (SScaleScreen.this.src_canvas.y + SScaleScreen.this.src_canvas.height > SScaleScreen.this.src_canvas.getImageHeight()) {
                        SScaleScreen.this.src_canvas.y = SScaleScreen.this.src_canvas.getImageHeight() - SScaleScreen.this.src_canvas.height;
                    }
                    SScaleScreen.this.src_canvas.paint(SScaleScreen.this.src_canvas.getGraphics());
                }
            }
        }
    }

    class MyMouseListener
    extends MouseInputAdapter {
        MyMouseListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            ScaleImageCanvas scaleImageCanvas = (ScaleImageCanvas)mouseEvent.getSource();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            int n4 = 0;
            int n5 = scaleImageCanvas.getImageWidth();
            int n6 = scaleImageCanvas.getImageHeight();
            if (n5 >= 256 || n6 >= 256) {
                float f;
                if (n5 > n6) {
                    f = (float)n5 / (float)n6;
                    n3 = 256;
                    n4 = (int)(256.0f / f);
                    SScaleScreen.this.actualx = (int)((float)n5 / (float)n3 * (float)n);
                    SScaleScreen.this.actualy = (int)((float)n6 / (float)n4 * (float)n2);
                } else if (n6 > n5) {
                    f = (float)n6 / (float)n5;
                    n3 = n5;
                    n4 = 256;
                    n3 = (int)(256.0f / f);
                    SScaleScreen.this.actualx = (int)((float)n5 / (float)n3 * (float)n);
                    SScaleScreen.this.actualy = (int)((float)n6 / (float)n4 * (float)n2);
                } else {
                    SScaleScreen.this.actualx = (int)((float)n5 / 256.0f * (float)n);
                    SScaleScreen.this.actualy = (int)((float)n6 / 256.0f * (float)n2);
                }
            } else {
                SScaleScreen.this.actualx = n;
                SScaleScreen.this.actualy = n2;
            }
            if (SScaleScreen.this.actualx < 0) {
                SScaleScreen.this.actualx = 0;
            }
            if (SScaleScreen.this.actualy < 0) {
                SScaleScreen.this.actualy = 0;
            }
            if (SScaleScreen.this.actualx > n5 - 1) {
                SScaleScreen.this.actualx = n5 - 1;
            }
            if (SScaleScreen.this.actualy > n6 - 1) {
                SScaleScreen.this.actualy = n6 - 1;
            }
            int n7 = SScaleScreen.this.src_1d[SScaleScreen.this.actualx + SScaleScreen.this.actualy * n5] & 0xFF;
            SScaleScreen.this.blPosition.setText("Point X:" + SScaleScreen.this.actualx + "  Y:" + SScaleScreen.this.actualy);
            SScaleScreen.this.blIntensity.setText("Intensity:" + n7);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ScaleImageCanvas scaleImageCanvas = (ScaleImageCanvas)mouseEvent.getSource();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (SScaleScreen.this.point == null) {
                SScaleScreen.this.point = new Point(n, n2);
            } else {
                SScaleScreen.this.point.x = n;
                SScaleScreen.this.point.y = n2;
            }
            scaleImageCanvas.x_Y(SScaleScreen.this.point.x, SScaleScreen.this.point.y);
        }
    }
}

