/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SThresholdScreen
extends HistVisionApplet {
    public int lowthresh = 64;
    public int highthresh = 192;
    private boolean inverted = false;
    private Threshold thresholdalgorithm;
    private SliderListener slhigh = new SliderListener();
    private SliderListener sllow = new SliderListener();
    private ComboListener cltoggle = new ComboListener();
    private ButtonListener startbl = new ButtonListener();
    private ButtonListener abortbl = new ButtonListener();
    private TextListener textListen = new TextListener();
    private GridBagLayout mllayout = new GridBagLayout();
    private GridBagLayout mrlayout = new GridBagLayout();
    private GridBagConstraints midlc = new GridBagConstraints();
    private GridBagConstraints midrc = new GridBagConstraints();
    private JLabel highlabel = new JLabel("High threshold value");
    private JLabel lowlabel = new JLabel("Low threshold value");
    private JTextField lowbox = new JTextField(4);
    private JTextField highbox = new JTextField(4);
    private JSlider highthreshold = new JSlider(0, 0, 255, this.highthresh);
    private JSlider lowthreshold = new JSlider(0, 0, 255, this.lowthresh);
    private JComboBox toggle = new JComboBox();
    private JButton startbutton = new JButton("Apply Threshold");
    private JButton abortbutton = new JButton("Abort");
    private JLabel time = new JLabel("Time");
    private JTextField time_taken = new JTextField(20);

    @Override
    public void add_extra() {
        this.thresholdalgorithm = new Threshold();
        this.midc.weighty = 0.5;
        this.midc.gridx = 0;
        this.midc.gridy = 0;
        this.midlayout.setConstraints(this.lowlabel, this.midc);
        this.mid.add(this.lowlabel);
        this.midc.gridx = 1;
        this.midc.gridy = 0;
        this.midlayout.setConstraints(this.lowbox, this.midc);
        this.mid.add(this.lowbox);
        this.lowbox.addActionListener(this.textListen);
        this.lowbox.setText("64");
        this.midc.gridx = 1;
        this.midc.gridy = 1;
        this.midc.weightx = 0.4;
        this.midc.fill = 2;
        this.midlayout.setConstraints(this.lowthreshold, this.midc);
        this.mid.add(this.lowthreshold);
        this.lowthreshold.addChangeListener(this.sllow);
        this.lowthreshold.setMajorTickSpacing(50);
        this.lowthreshold.setMinorTickSpacing(5);
        this.lowthreshold.setPaintTicks(true);
        this.lowthreshold.setPaintLabels(true);
        this.midc.weightx = 0.0;
        this.midc.fill = 0;
        this.midc.gridx = 0;
        this.midc.gridy = 2;
        this.midlayout.setConstraints(this.highlabel, this.midc);
        this.mid.add(this.highlabel);
        this.midc.gridx = 1;
        this.midc.gridy = 2;
        this.midlayout.setConstraints(this.highbox, this.midc);
        this.mid.add(this.highbox);
        this.highbox.addActionListener(this.textListen);
        this.highbox.setText("192");
        this.midc.gridx = 1;
        this.midc.gridy = 3;
        this.midc.weightx = 0.4;
        this.midc.fill = 2;
        this.midlayout.setConstraints(this.highthreshold, this.midc);
        this.mid.add(this.highthreshold);
        this.highthreshold.setMajorTickSpacing(50);
        this.highthreshold.setMinorTickSpacing(5);
        this.highthreshold.setPaintTicks(true);
        this.highthreshold.setPaintLabels(true);
        this.highthreshold.addChangeListener(this.slhigh);
        this.midc.weightx = 0.0;
        this.midc.fill = 0;
        this.midc.gridwidth = 1;
        this.midc.gridx = 0;
        this.midc.gridy = 4;
        this.toggle.addItem("Normal");
        this.toggle.addItem("Inverted");
        this.midlayout.setConstraints(this.toggle, this.midc);
        this.mid.add(this.toggle);
        this.toggle.addActionListener(this.cltoggle);
        this.midc.gridx = 0;
        this.midc.gridy = 5;
        this.midlayout.setConstraints(this.startbutton, this.midc);
        this.startbutton.setBackground(Color.green);
        this.mid.add(this.startbutton);
        this.startbutton.addActionListener(this.startbl);
        this.midc.gridx = -1;
        this.abortbutton.setBackground(Color.red);
        this.midlayout.setConstraints(this.abortbutton, this.midc);
        this.mid.add(this.abortbutton);
        this.abortbutton.addActionListener(this.abortbl);
        this.midc.gridx = 0;
        this.midc.gridy = 6;
        this.midlayout.setConstraints(this.time, this.midc);
        this.mid.add(this.time);
        this.midc.gridx = 1;
        this.midc.gridy = 6;
        this.midlayout.setConstraints(this.time_taken, this.midc);
        this.time_taken.setEditable(false);
        this.mid.add(this.time_taken);
        this.mid.repaint();
    }

    @Override
    public void set_src_image(int[] nArray, int n, int n2, String string) {
        this.set_src_image2(nArray, n, n2, string);
        this.thresholdalgorithm = new Threshold();
        this.lowbox.setText("64");
        this.highbox.setText("192");
        this.highthreshold.setValue(192);
        this.lowthreshold.setValue(64);
    }

    @Override
    public String getAppletInfo() {
        return "An applet for thresholding an image :part of the hiprjava.iface package. Written by Judy Robertson, SELLIC OnLine, Timothy Sharman";
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == SThresholdScreen.this.startbutton) {
                SThresholdScreen.this.time_msec = System.currentTimeMillis();
                if (SThresholdScreen.this.lowthresh > SThresholdScreen.this.highthresh) {
                    JOptionPane.showMessageDialog(null, "Low threshold must be smaller than high threshold", "Error!", 2);
                } else {
                    SThresholdScreen.this.dest_1d = SThresholdScreen.this.thresholdalgorithm.twothreshold(SThresholdScreen.this.src_1d, SThresholdScreen.this.i_w, SThresholdScreen.this.i_h, SThresholdScreen.this.lowthresh, SThresholdScreen.this.highthresh);
                    if (SThresholdScreen.this.inverted) {
                        SThresholdScreen.this.dest_1d = SThresholdScreen.this.thresholdalgorithm.flip_the_pixels(SThresholdScreen.this.dest_1d, SThresholdScreen.this.i_w, SThresholdScreen.this.i_h);
                    }
                    SThresholdScreen.this.time_msec = System.currentTimeMillis() - SThresholdScreen.this.time_msec;
                    SThresholdScreen.this.time_taken.setText(new Long(SThresholdScreen.this.time_msec).toString() + " msecs");
                    SThresholdScreen.this.dest = SThresholdScreen.this.createImage(new MemoryImageSource(SThresholdScreen.this.i_w, SThresholdScreen.this.i_h, SThresholdScreen.this.dest_1d, 0, SThresholdScreen.this.i_w));
                    SThresholdScreen.this.dest_canvas.updateImage(SThresholdScreen.this.dest);
                    SThresholdScreen.this.outsize.setText(SThresholdScreen.this.d_w + " x " + SThresholdScreen.this.d_h);
                    SThresholdScreen.this.container.validate();
                    HistVisionApplet.PixelListener pixelListener = new HistVisionApplet.PixelListener(SThresholdScreen.this);
                    SThresholdScreen.this.dest_canvas.addMouseMotionListener(pixelListener);
                }
            } else if (jButton == SThresholdScreen.this.abortbutton) {
                SThresholdScreen.this.time_taken.setText("");
            }
        }
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (SThresholdScreen.this.histogramalgorithm != null) {
                if (jSlider == SThresholdScreen.this.highthreshold) {
                    SThresholdScreen.this.highthresh = SThresholdScreen.this.highthreshold.getValue();
                    SThresholdScreen.this.highbox.setText(String.valueOf(SThresholdScreen.this.highthreshold.getValue()));
                    SThresholdScreen.this.hist_canvas.highthresh = SThresholdScreen.this.highthresh;
                    SThresholdScreen.this.hist_canvas.invalidate();
                    SThresholdScreen.this.hist_canvas.repaint();
                }
                if (jSlider == SThresholdScreen.this.lowthreshold) {
                    SThresholdScreen.this.lowthresh = SThresholdScreen.this.lowthreshold.getValue();
                    SThresholdScreen.this.lowbox.setText(String.valueOf(SThresholdScreen.this.lowthreshold.getValue()));
                    SThresholdScreen.this.hist_canvas.lowthresh = SThresholdScreen.this.lowthresh;
                    SThresholdScreen.this.hist_canvas.invalidate();
                    SThresholdScreen.this.hist_canvas.repaint();
                }
            }
        }
    }

    class TextListener
    implements ActionListener {
        TextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            try {
                int n = Integer.valueOf(jTextField.getText());
                if (n >= 0 && n <= 255) {
                    if (jTextField == SThresholdScreen.this.lowbox) {
                        SThresholdScreen.this.lowthreshold.setValue(n);
                    } else if (jTextField == SThresholdScreen.this.highbox) {
                        SThresholdScreen.this.highthreshold.setValue(n);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Threshold must lie between 0 and 255", "Error!", 2);
                    if (jTextField == SThresholdScreen.this.lowbox) {
                        SThresholdScreen.this.lowthreshold.setValue(64);
                        SThresholdScreen.this.lowbox.setText("64");
                    } else if (jTextField == SThresholdScreen.this.highbox) {
                        SThresholdScreen.this.highthreshold.setValue(192);
                        SThresholdScreen.this.highbox.setText("192");
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, "Invalid threshold specified", "Error!", 2);
            }
        }
    }

    class ComboListener
    implements ActionListener {
        ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.getSelectedItem().equals("Normal")) {
                SThresholdScreen.this.inverted = false;
            } else if (jComboBox.getSelectedItem().equals("Inverted")) {
                SThresholdScreen.this.inverted = true;
            }
        }
    }
}

