/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.MouseInputAdapter;

public class STranslateScreen
extends VisionApplet1 {
    private TranslateImageCanvas src_canvas;
    private boolean wrap;
    public Point point = null;
    int startx;
    int starty;
    int currx;
    int curry;
    boolean clicked = false;
    Translate translate;
    private ComboListener clwrap = new ComboListener();
    private ButtonListener startbl = new ButtonListener();
    private ButtonListener abortbl = new ButtonListener();
    private MyMouseListener mousel = new MyMouseListener();
    private TextListener transtl = new TextListener();
    private JButton startbutton = new JButton("Translate");
    private JButton abortbutton = new JButton("Stop");
    private JLabel time = new JLabel("Time");
    private JTextField time_taken = new JTextField(20);
    private JLabel wrap_label = new JLabel("Wrap/NoWrap :");
    private JComboBox wrap_chooser = new JComboBox();
    private JLabel xLabel = new JLabel("X Translation:");
    private JLabel yLabel = new JLabel("Y Translation:");
    private JTextField xBox = new JTextField(5);
    private JTextField yBox = new JTextField(5);

    @Override
    public void add_extra() {
        this.wrap = true;
        this.translate = new Translate();
        this.midc.weighty = 0.5;
        this.midc.gridx = 0;
        this.midc.gridy = 0;
        this.midlayout.setConstraints(this.wrap_label, this.midc);
        this.mid.add(this.wrap_label);
        this.midc.gridx = 1;
        this.midc.gridy = 0;
        this.wrap_chooser.addItem("Wrap");
        this.wrap_chooser.addItem("No Wrap");
        this.midlayout.setConstraints(this.wrap_chooser, this.midc);
        this.mid.add(this.wrap_chooser);
        this.wrap_chooser.addActionListener(this.clwrap);
        this.midc.gridx = 0;
        this.midc.gridy = 1;
        this.midlayout.setConstraints(this.xLabel, this.midc);
        this.mid.add(this.xLabel);
        this.midc.gridx = 1;
        this.midc.gridy = 1;
        this.midlayout.setConstraints(this.xBox, this.midc);
        this.mid.add(this.xBox);
        this.xBox.setText("0");
        this.xBox.addKeyListener(this.transtl);
        this.midc.gridx = 0;
        this.midc.gridy = 2;
        this.midlayout.setConstraints(this.yLabel, this.midc);
        this.mid.add(this.yLabel);
        this.midc.gridx = 1;
        this.midc.gridy = 2;
        this.midlayout.setConstraints(this.yBox, this.midc);
        this.mid.add(this.yBox);
        this.yBox.setText("0");
        this.yBox.addKeyListener(this.transtl);
        this.midc.gridx = 0;
        this.midc.gridy = 3;
        this.midlayout.setConstraints(this.startbutton, this.midc);
        this.startbutton.setBackground(Color.green);
        this.mid.add(this.startbutton);
        this.startbutton.addActionListener(this.startbl);
        this.midc.gridx = -1;
        this.abortbutton.setBackground(Color.red);
        this.midlayout.setConstraints(this.abortbutton, this.midc);
        this.mid.add(this.abortbutton);
        this.abortbutton.addActionListener(this.abortbl);
        this.midc.gridx = 0;
        this.midc.gridy = 4;
        this.midlayout.setConstraints(this.time, this.midc);
        this.mid.add(this.time);
        this.midc.gridx = 1;
        this.midc.gridy = 4;
        this.midlayout.setConstraints(this.time_taken, this.midc);
        this.time_taken.setEditable(false);
        this.mid.add(this.time_taken);
        this.mid.repaint();
    }

    @Override
    public void set_src_image(int[] nArray, int n, int n2, String string) {
        this.i_w = n;
        this.i_h = n2;
        this.src_1d = new int[this.i_w * this.i_h];
        this.src_1d = nArray;
        this.src = this.createImage(new MemoryImageSource(this.i_w, this.i_h, this.src_1d, 0, this.i_w));
        if (this.src_canvas != null) {
            this.bl.remove(this.src_canvas);
        }
        this.src_canvas = new TranslateImageCanvas(this.src);
        this.blc.gridx = 0;
        this.blc.gridy = 1;
        this.bllayout.setConstraints(this.src_canvas, this.blc);
        this.bl.add(this.src_canvas);
        this.bl.validate();
        this.bl.repaint();
        this.insize.setText(this.i_w + " x " + this.i_h);
        MyMouseListener myMouseListener = new MyMouseListener();
        this.src_canvas.addMouseListener(myMouseListener);
        this.src_canvas.addMouseMotionListener(myMouseListener);
        this.translate = new Translate();
        this.d_w = this.i_w;
        this.d_h = this.i_h;
        this.dest_1d = new int[this.i_w * this.i_h];
        this.dest_1d = nArray;
        this.dest = this.createImage(new MemoryImageSource(this.d_w, this.d_h, this.dest_1d, 0, this.d_w));
        if (this.dest_canvas != null) {
            this.br.remove(this.dest_canvas);
        }
        this.dest_canvas = new ImageCanvas(this.dest);
        this.brc.gridx = 0;
        this.brc.gridy = 1;
        this.brlayout.setConstraints(this.dest_canvas, this.brc);
        this.br.add(this.dest_canvas);
        this.outsize.setText(this.d_w + " x " + this.d_h);
        this.container.validate();
        this.container.repaint();
        this.clicked = false;
        this.xBox.setText("0");
        this.yBox.setText("0");
        this.startx = 0;
        this.starty = 0;
        this.src_canvas.endLine(0, 0);
        VisionApplet1.PixelListener pixelListener = new VisionApplet1.PixelListener(this);
        this.dest_canvas.addMouseMotionListener(pixelListener);
        this.blPosition.setText("Point X:  Y: ");
        this.blIntensity.setText("Intensity: ");
        this.brPosition.setText("Point X:  Y: ");
        this.brIntensity.setText("Intensity: ");
    }

    @Override
    public void set_image() {
        Object object;
        String string = "brg1.gif";
        try {
            object = new URL(this.getDocumentBase(), "images/" + string);
            this.src = this.getImage((URL)object);
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(null, "The default file is not present", "Load Error", 2);
            return;
        }
        this.src_canvas = new TranslateImageCanvas(this.src);
        this.dest_canvas = new ImageCanvas(this.src);
        this.i_w = this.src_canvas.getImageWidth();
        this.i_h = this.src_canvas.getImageHeight();
        this.src_1d = new int[this.i_w * this.i_h];
        object = new PixelGrabber(this.src, 0, 0, this.i_w, this.i_h, this.src_1d, 0, this.i_w);
        try {
            ((PixelGrabber)object).grabPixels();
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(null, "Unable to handle default file", "Load Error", 2);
            return;
        }
        if ((((PixelGrabber)object).status() & 0x80) != 0) {
            JOptionPane.showMessageDialog(null, "The default image file cannot be loaded", "Load Error", 2);
            return;
        }
        this.d_w = this.i_w;
        this.d_h = this.i_h;
        this.dest_1d = new int[this.d_w * this.d_h];
        for (int i = 0; i < this.dest_1d.length; ++i) {
            this.dest_1d[i] = this.src_1d[i];
        }
    }

    @Override
    public void gui_add_image() {
        this.blc.gridx = 0;
        this.blc.gridy = 1;
        this.bllayout.setConstraints(this.src_canvas, this.blc);
        this.bl.add(this.src_canvas);
        MyMouseListener myMouseListener = new MyMouseListener();
        this.src_canvas.addMouseListener(myMouseListener);
        this.src_canvas.addMouseMotionListener(myMouseListener);
        this.brc.gridx = 0;
        this.brc.gridy = 1;
        this.brlayout.setConstraints(this.dest_canvas, this.brc);
        this.br.add(this.dest_canvas);
        this.dest_canvas.addMouseMotionListener(this.brpl);
    }

    @Override
    public void apply_send_image() {
        MediaTracker mediaTracker = new MediaTracker(this);
        Image image = this.getImage(this.theURL);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        if (mediaTracker.statusID(0, false) == 4) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        TranslateImageCanvas translateImageCanvas = new TranslateImageCanvas(image);
        int n = translateImageCanvas.getImageWidth();
        int n2 = translateImageCanvas.getImageHeight();
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        if ((pixelGrabber.status() & 0x80) != 0) {
            JOptionPane.showMessageDialog(null, "Unable to load image - try again", "Load Error", 2);
            return;
        }
        this.set_src_image(nArray, n, n2, this.image_url);
    }

    @Override
    public String getAppletInfo() {
        return "An applet for applying translation to an image. Written by Craig Strachan, heavily based on code by Judy Robertson, SELLIC OnLine, Timothy Sharman";
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == STranslateScreen.this.startbutton) {
                STranslateScreen.this.xBox.setText(Integer.toString(((STranslateScreen)STranslateScreen.this).src_canvas.end_x - ((STranslateScreen)STranslateScreen.this).src_canvas.start_x));
                STranslateScreen.this.yBox.setText(Integer.toString(((STranslateScreen)STranslateScreen.this).src_canvas.end_y - ((STranslateScreen)STranslateScreen.this).src_canvas.start_y));
                STranslateScreen.this.time_msec = System.currentTimeMillis();
                STranslateScreen.this.dest_1d = STranslateScreen.this.translate.translate_image(STranslateScreen.this.src_1d, STranslateScreen.this.i_h, STranslateScreen.this.i_w, ((STranslateScreen)STranslateScreen.this).src_canvas.end_x - ((STranslateScreen)STranslateScreen.this).src_canvas.start_x, ((STranslateScreen)STranslateScreen.this).src_canvas.end_y - ((STranslateScreen)STranslateScreen.this).src_canvas.start_y, STranslateScreen.this.wrap);
                STranslateScreen.this.time_msec = System.currentTimeMillis() - STranslateScreen.this.time_msec;
                STranslateScreen.this.time_taken.setText(new Long(STranslateScreen.this.time_msec).toString() + " msecs");
                STranslateScreen.this.dest = STranslateScreen.this.createImage(new MemoryImageSource(STranslateScreen.this.i_w, STranslateScreen.this.i_h, STranslateScreen.this.dest_1d, 0, STranslateScreen.this.i_w));
                if (STranslateScreen.this.dest_canvas != null) {
                    STranslateScreen.this.br.remove(STranslateScreen.this.dest_canvas);
                }
                STranslateScreen.this.dest_canvas = new ImageCanvas(STranslateScreen.this.dest);
                VisionApplet1.PixelListener pixelListener = new VisionApplet1.PixelListener(STranslateScreen.this);
                STranslateScreen.this.dest_canvas.addMouseMotionListener(pixelListener);
                STranslateScreen.this.brc.gridx = 0;
                STranslateScreen.this.brc.gridy = 1;
                STranslateScreen.this.brlayout.setConstraints(STranslateScreen.this.dest_canvas, STranslateScreen.this.brc);
                STranslateScreen.this.br.add(STranslateScreen.this.dest_canvas);
                STranslateScreen.this.br.validate();
                STranslateScreen.this.br.doLayout();
                STranslateScreen.this.container.validate();
            } else if (jButton == STranslateScreen.this.abortbutton) {
                STranslateScreen.this.time_taken.setText("");
            }
        }
    }

    class ComboListener
    implements ActionListener {
        ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.getSelectedItem().equals("Wrap")) {
                STranslateScreen.this.wrap = true;
            } else if (jComboBox.getSelectedItem().equals("No Wrap")) {
                STranslateScreen.this.wrap = false;
            }
        }
    }

    class MyMouseListener
    extends MouseInputAdapter {
        MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            TranslateImageCanvas translateImageCanvas = (TranslateImageCanvas)mouseEvent.getSource();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            STranslateScreen.this.startx = n;
            STranslateScreen.this.starty = n2;
            if (STranslateScreen.this.point == null) {
                STranslateScreen.this.point = new Point(n, n2);
            } else {
                STranslateScreen.this.point.x = n;
                STranslateScreen.this.point.y = n2;
            }
            translateImageCanvas.setStart(STranslateScreen.this.point.x, STranslateScreen.this.point.y);
            STranslateScreen.this.clicked = true;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            TranslateImageCanvas translateImageCanvas = (TranslateImageCanvas)mouseEvent.getSource();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (STranslateScreen.this.point == null) {
                STranslateScreen.this.point = new Point(n, n2);
            } else {
                STranslateScreen.this.point.x = n;
                STranslateScreen.this.point.y = n2;
            }
            translateImageCanvas.updateLine(STranslateScreen.this.point.x, STranslateScreen.this.point.y);
            STranslateScreen.this.xBox.setText("" + (n - STranslateScreen.this.startx) + "");
            STranslateScreen.this.yBox.setText("" + (n2 - STranslateScreen.this.starty) + "");
            int n3 = mouseEvent.getX();
            int n4 = mouseEvent.getY();
            int n5 = 0;
            int n6 = 0;
            int n7 = translateImageCanvas.getImageWidth();
            int n8 = translateImageCanvas.getImageHeight();
            if (n7 >= 256 || n8 >= 256) {
                float f;
                if (n7 > n8) {
                    f = (float)n7 / (float)n8;
                    n5 = 256;
                    n6 = (int)(256.0f / f);
                    STranslateScreen.this.actualx = (int)((float)n7 / (float)n5 * (float)n3);
                    STranslateScreen.this.actualy = (int)((float)n8 / (float)n6 * (float)n4);
                } else if (n8 > n7) {
                    f = (float)n8 / (float)n7;
                    n5 = n7;
                    n6 = 256;
                    n5 = (int)(256.0f / f);
                    STranslateScreen.this.actualx = (int)((float)n7 / (float)n5 * (float)n3);
                    STranslateScreen.this.actualy = (int)((float)n8 / (float)n6 * (float)n4);
                } else {
                    STranslateScreen.this.actualx = (int)((float)n7 / 256.0f * (float)n3);
                    STranslateScreen.this.actualy = (int)((float)n8 / 256.0f * (float)n4);
                }
            } else {
                STranslateScreen.this.actualx = n3;
                STranslateScreen.this.actualy = n4;
            }
            if (STranslateScreen.this.actualx < 0) {
                STranslateScreen.this.actualx = 0;
            }
            if (STranslateScreen.this.actualy < 0) {
                STranslateScreen.this.actualy = 0;
            }
            if (STranslateScreen.this.actualx > n7 - 1) {
                STranslateScreen.this.actualx = n7 - 1;
            }
            if (STranslateScreen.this.actualy > n8 - 1) {
                STranslateScreen.this.actualy = n8 - 1;
            }
            int n9 = STranslateScreen.this.src_1d[STranslateScreen.this.actualx + STranslateScreen.this.actualy * n7] & 0xFF;
            STranslateScreen.this.blPosition.setText("Point X:" + STranslateScreen.this.actualx + "  Y:" + STranslateScreen.this.actualy);
            STranslateScreen.this.blIntensity.setText("Intensity:" + n9);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            TranslateImageCanvas translateImageCanvas = (TranslateImageCanvas)mouseEvent.getSource();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (STranslateScreen.this.point == null) {
                STranslateScreen.this.point = new Point(n, n2);
            } else {
                STranslateScreen.this.point.x = n;
                STranslateScreen.this.point.y = n2;
            }
            translateImageCanvas.endLine(STranslateScreen.this.point.x, STranslateScreen.this.point.y);
        }
    }

    class TextListener
    extends KeyAdapter {
        TextListener() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            block5: {
                JTextField jTextField = (JTextField)keyEvent.getSource();
                try {
                    int n;
                    if (!STranslateScreen.this.clicked) {
                        STranslateScreen.this.src_canvas.setStart(1, 1);
                        STranslateScreen.this.startx = 1;
                        STranslateScreen.this.starty = 1;
                    }
                    int n2 = Integer.valueOf(jTextField.getText());
                    if (jTextField == STranslateScreen.this.xBox) {
                        n = Integer.valueOf(STranslateScreen.this.yBox.getText());
                        STranslateScreen.this.src_canvas.endLine(n2 + STranslateScreen.this.startx, n + STranslateScreen.this.starty);
                    }
                    if (jTextField == STranslateScreen.this.yBox) {
                        n = Integer.valueOf(STranslateScreen.this.xBox.getText());
                        STranslateScreen.this.src_canvas.endLine(n + STranslateScreen.this.startx, n2 + STranslateScreen.this.starty);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (jTextField.getText().equals("")) break block5;
                    JOptionPane.showMessageDialog(null, "Invalid translation specified", "Error!", 2);
                }
            }
        }
    }
}

