/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class TranslateImageCanvas
extends NoScaleImageCanvas {
    public int start_x = -1;
    public int start_y = -1;
    public int end_x = -1;
    public int end_y = -1;
    private boolean dragging = false;
    public float ratio = 1.0f;

    public TranslateImageCanvas(Image image) {
        super(image);
    }

    public void setStart(int n, int n2) {
        this.start_x = (int)((float)n * this.ratio);
        this.start_y = (int)((float)n2 * this.ratio);
    }

    public void updateLine(int n, int n2) {
        this.end_x = (int)((float)n * this.ratio);
        this.end_y = (int)((float)n2 * this.ratio);
        if (n < 0) {
            this.end_x = 1;
        }
        if (n2 < 0) {
            this.end_y = 1;
        }
        if (n > 256) {
            this.end_x = 255;
        }
        if (n2 > 256) {
            this.end_y = 255;
        }
        this.paint(this.getGraphics());
    }

    public void endLine(int n, int n2) {
        this.end_x = n < 0 ? 0 : (n > 256 ? 256 : (int)((float)n * this.ratio));
        this.end_y = n2 < 0 ? 0 : (n2 > 256 ? 256 : (int)((float)n2 * this.ratio));
        this.paint(this.getGraphics());
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.image_width >= 256 || this.image_height >= 256) {
            this.ratio = this.image_width > this.image_height ? (float)this.image_width / 256.0f : (float)this.image_height / 256.0f;
        }
        graphics.setColor(Color.red);
        if (this.start_x != -1 && this.start_y != -1) {
            graphics.drawLine((int)((float)this.start_x / this.ratio), (int)((float)this.start_y / this.ratio), (int)((float)this.end_x / this.ratio), (int)((float)this.end_y / this.ratio));
            if (!this.dragging) {
                // empty if block
            }
        }
    }
}

