/*
 * Decompiled with CFR 0.152.
 */
public class Boundary
extends Thread {
    int[] output;
    int[][] intermediate;
    int w;
    int h;
    int[] dx = new int[8];
    int[] dy = new int[8];
    int vec;
    int oldvec;

    public Boundary() {
        this.dx[0] = 0;
        this.dx[1] = -1;
        this.dx[2] = -1;
        this.dx[3] = -1;
        this.dx[4] = 0;
        this.dx[5] = 1;
        this.dx[6] = 1;
        this.dx[7] = 1;
        this.dy[0] = -1;
        this.dy[1] = -1;
        this.dy[2] = 0;
        this.dy[3] = 1;
        this.dy[4] = 1;
        this.dy[5] = 1;
        this.dy[6] = 0;
        this.dy[7] = -1;
    }

    public void single_track(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n;
        int n9 = n2;
        for (n7 = 2; n7 < 8; ++n7) {
            n6 = n + this.dx[n7];
            n5 = n2 + this.dy[n7];
            if (n6 < 0 || n5 < 0 || n6 >= this.w || n5 >= this.h || this.intermediate[n6][n5] != 255) continue;
            this.vec = n7;
            break;
        }
        n += this.dx[this.vec];
        n2 += this.dy[this.vec];
        while (n != n8 || n2 != n9) {
            if (n < 0 || n2 < 0 || n >= this.w || n2 >= this.h) {
                System.out.println("Terminating track at image boundary at xy(" + n + "," + n2 + ")");
                return;
            }
            this.intermediate[n][n2] = 128;
            this.oldvec = (this.vec + 4) % 8;
            this.vec = (this.oldvec + 1) % 8;
            n7 = 0;
            n6 = n + this.dx[this.vec];
            n5 = n2 + this.dy[this.vec];
            if (n6 < 0 || n5 < 0 || n6 >= this.w || n5 >= this.h) {
                System.out.println("Terminating track at image boundary at xy(" + n + "," + n2 + ")");
                return;
            }
            while (this.intermediate[n + this.dx[this.vec]][n2 + this.dy[this.vec]] != 255) {
                this.vec = (this.vec + 1) % 8;
                if (++n7 > 8) {
                    System.out.println("Terminating track due to loop error at xy(" + n + "," + n2 + ")");
                    return;
                }
                n6 = n + this.dx[this.vec];
                n5 = n2 + this.dy[this.vec];
                if (n6 >= 0 && n5 >= 0 && n6 < this.w && n5 < this.h) continue;
                System.out.println("Terminating track at image boundary at xy(" + n + "," + n2 + ")");
                return;
            }
            n4 = 0;
            for (n3 = 0; n3 < 8; ++n3) {
                n6 = n + this.dx[n3] + this.dx[this.vec];
                n5 = n2 + this.dy[n3] + this.dy[this.vec];
                if (n6 < 0 || n5 < 0 || n6 >= this.w || n5 >= this.h || this.intermediate[n6][n5] != 0) continue;
                n4 = 1;
                break;
            }
            if (n4 == 0) {
                System.out.println("Terminating on internal point at xy(" + n + "," + n2 + ")");
                return;
            }
            n += this.dx[this.vec];
            n2 += this.dy[this.vec];
        }
        this.intermediate[n][n2] = 128;
        for (n7 = 1; n7 < this.h - 1; ++n7) {
            for (n4 = 1; n4 < this.w - 1; ++n4) {
                if (this.intermediate[n4][n7] != 128) continue;
                for (n3 = 0; n3 < 8; ++n3) {
                    n6 = n4 + this.dx[n3];
                    n5 = n7 + this.dy[n3];
                    if (n6 < 0 || n5 < 0 || n6 >= this.w || n5 >= this.h || this.intermediate[n6][n5] != 255) continue;
                    this.clear_interior(n6, n5);
                }
            }
        }
        for (n7 = 0; n7 < this.h; ++n7) {
            for (n4 = 0; n4 < this.w; ++n4) {
                if (this.intermediate[n4][n7] == 64) {
                    this.intermediate[n4][n7] = 0;
                }
                if (this.intermediate[n4][n7] != 192) continue;
                this.intermediate[n4][n7] = 255;
            }
        }
    }

    public void clear_interior(int n, int n2) {
        int[] nArray = new int[this.w * this.h];
        int[] nArray2 = new int[this.w * this.h];
        int n3 = 1;
        nArray[0] = n;
        nArray2[0] = n2;
        while (n3 > 0) {
            int n4;
            int n5;
            int n6;
            if (this.intermediate[n = nArray[--n3]][n2 = nArray2[n3]] != 255) continue;
            boolean bl = false;
            boolean bl2 = false;
            for (n6 = 0; n6 < 8; ++n6) {
                n5 = n + this.dx[n6];
                n4 = n2 + this.dy[n6];
                if (n5 < 0 || n4 < 0 || n5 >= this.w || n4 >= this.h) continue;
                if (this.intermediate[n5][n4] == 0) {
                    bl = true;
                }
                if (this.intermediate[n5][n4] != 128) continue;
                bl2 = true;
            }
            this.intermediate[n][n2] = !bl || bl && bl2 ? 64 : 192;
            for (n6 = 0; n6 < 8; ++n6) {
                n5 = n + this.dx[n6];
                n4 = n2 + this.dy[n6];
                if (n5 < 0 || n4 < 0 || n5 >= this.w || n4 >= this.h || this.intermediate[n5][n4] != 255) continue;
                nArray[n3] = n5;
                nArray2[n3] = n4;
                ++n3;
            }
        }
    }

    public boolean starting_point(int n, int n2) {
        if (this.intermediate[n][n2] == 0) {
            return false;
        }
        if (this.intermediate[n][n2] == 128) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < 8; ++i) {
            int n3 = n + this.dx[i];
            int n4 = n2 + this.dy[i];
            if (n3 < 0 || n4 < 0 || n3 >= this.w || n4 >= this.h) continue;
            if (this.intermediate[n3][n4] == 0) {
                bl2 = true;
            }
            if (this.intermediate[n3][n4] != 255) continue;
            bl = false;
        }
        return bl2 && !bl;
    }

    public BinaryFast apply_boundary(BinaryFast binaryFast, int n, int n2) {
        int n3;
        int n4;
        this.intermediate = new int[n][n2];
        this.w = n;
        this.h = n2;
        for (n4 = 0; n4 < this.h; ++n4) {
            for (n3 = 0; n3 < this.w; ++n3) {
                int n5 = binaryFast.pixels[n3][n4] & 0xFF;
                if (n5 > 0) {
                    n5 = 255;
                }
                this.intermediate[n3][n4] = n5;
            }
        }
        for (n4 = 1; n4 < this.h - 1; ++n4) {
            for (n3 = 1; n3 < this.w - 1; ++n3) {
                if (!this.starting_point(n3, n4)) continue;
                this.single_track(n3, n4);
            }
        }
        for (n4 = 0; n4 < this.h; ++n4) {
            for (n3 = 0; n3 < this.w; ++n3) {
                this.intermediate[n3][n4] = this.intermediate[n3][n4] == 128 ? -1 : -16777216;
            }
        }
        BinaryFast binaryFast2 = new BinaryFast(this.intermediate, this.w, this.h);
        return binaryFast2;
    }
}

