/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StreamTokenizer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class fourier
extends operator1DInt {
    JPanel fftPanel = new JPanel();
    JPanel ifftPanel = new JPanel();
    JComboBox fftchoice = new JComboBox();
    JComboBox ifftchoice = new JComboBox();
    int fftmod;
    int ifftmod;
    JPanel filterPanel = new JPanel();
    int h;
    int w;
    TwoDArray fres;
    TwoDArray ires;
    double[][] fouriers;
    double[][] ifouriers;
    double[][] fmask;
    double[][] imask;
    FFT fourierOp;
    InverseFFT inverse;
    static int number = 0;
    String type = new String("Fourier");

    public fourier() {
    }

    public fourier(JPanel jPanel, linkData linkData2) {
        this.setName(this.type + "_" + ++number);
        this.setParameters();
        this.setType(this.type);
        this.setBox(jPanel, linkData2, 2, 2);
        this.box.getIn2().setText("FFTMask");
        this.box.getOut1().setText("FFT");
        this.box.getOut2().setText("IFFT");
    }

    @Override
    public void loadParameters(StreamTokenizer streamTokenizer) throws IOException {
        int n = streamTokenizer.nextToken();
        this.fftmod = (int)streamTokenizer.nval;
        switch (this.fftmod) {
            case 0: {
                this.fftchoice.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.fftchoice.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.fftchoice.setSelectedIndex(2);
                break;
            }
            case 3: {
                this.fftchoice.setSelectedIndex(3);
                break;
            }
            case 4: {
                this.fftchoice.setSelectedIndex(4);
                break;
            }
            case 5: {
                this.fftchoice.setSelectedIndex(5);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(null, "Invalid FFT display option", "Error!", 2);
                return;
            }
        }
        n = streamTokenizer.nextToken();
        this.ifftmod = (int)streamTokenizer.nval;
        switch (this.ifftmod) {
            case 0: {
                this.ifftchoice.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.ifftchoice.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.ifftchoice.setSelectedIndex(2);
                break;
            }
            case 3: {
                this.ifftchoice.setSelectedIndex(3);
                break;
            }
            case 4: {
                this.ifftchoice.setSelectedIndex(4);
                break;
            }
            case 5: {
                this.ifftchoice.setSelectedIndex(5);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(null, "Invalid FFT display option", "Error!", 2);
                return;
            }
        }
        this.parameters.pack();
        this.parameters.setVisible(false);
    }

    @Override
    public String saveParameters() {
        String string = new String();
        string = " " + this.fftmod + " " + this.ifftmod;
        return string;
    }

    void setParameters() {
        this.parameters = new JFrame(this.name);
        this.panel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panel.setLayout(gridBagLayout);
        this.fftchoice.addItem("Magnitude");
        this.fftchoice.addItem("Magnitude log");
        this.fftchoice.addItem("Phase angle");
        this.fftchoice.addItem("Real");
        this.fftchoice.addItem("Real log");
        this.fftchoice.addItem("Imaginary");
        this.fftchoice.addItem("imaginary log");
        JLabel jLabel = new JLabel("FFT Display");
        this.fftPanel.setLayout(new BorderLayout());
        this.fftPanel.add((Component)jLabel, "North");
        this.fftPanel.add((Component)this.fftchoice, "South");
        this.ifftchoice.addItem("Magnitude");
        this.ifftchoice.addItem("Magnitude log");
        this.ifftchoice.addItem("Phase angle");
        this.ifftchoice.addItem("Real");
        this.ifftchoice.addItem("Real log");
        this.ifftchoice.addItem("Imaginary");
        this.ifftchoice.addItem("imaginary log");
        JLabel jLabel2 = new JLabel(" Inverse FFT Display");
        this.ifftPanel.setLayout(new BorderLayout());
        this.ifftPanel.add((Component)jLabel2, "North");
        this.ifftPanel.add((Component)this.ifftchoice, "South");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.fftPanel, gridBagConstraints);
        this.panel.add(this.fftPanel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.ifftPanel, gridBagConstraints);
        this.panel.add(this.ifftPanel);
        this.fftchoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                if (jComboBox.getSelectedItem().equals("Magnitude")) {
                    fourier.this.fftmod = 0;
                    fourier.this.display();
                } else if (jComboBox.getSelectedItem().equals("Magnitude log")) {
                    fourier.this.fftmod = 1;
                    fourier.this.display();
                } else if (jComboBox.getSelectedItem().equals("Phase angle")) {
                    fourier.this.fftmod = 2;
                    fourier.this.display();
                } else if (jComboBox.getSelectedItem().equals("Real")) {
                    fourier.this.fftmod = 3;
                    fourier.this.display();
                } else if (jComboBox.getSelectedItem().equals("Real log")) {
                    fourier.this.fftmod = 4;
                    fourier.this.display();
                } else if (jComboBox.getSelectedItem().equals("Imaginary")) {
                    fourier.this.fftmod = 5;
                    fourier.this.display();
                } else {
                    fourier.this.fftmod = 6;
                    fourier.this.display();
                }
            }
        });
        this.ifftchoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                if (jComboBox.getSelectedItem().equals("Magnitude")) {
                    fourier.this.ifftmod = 0;
                    fourier.this.display();
                } else if (jComboBox.getSelectedItem().equals("Magnitude log")) {
                    fourier.this.ifftmod = 1;
                    fourier.this.display();
                } else if (jComboBox.getSelectedItem().equals("Phase angle")) {
                    fourier.this.ifftmod = 2;
                    fourier.this.display();
                } else if (jComboBox.getSelectedItem().equals("Real")) {
                    fourier.this.ifftmod = 3;
                    fourier.this.display();
                } else if (jComboBox.getSelectedItem().equals("Real log")) {
                    fourier.this.ifftmod = 4;
                    fourier.this.display();
                } else if (jComboBox.getSelectedItem().equals("Imaginary")) {
                    fourier.this.ifftmod = 5;
                    fourier.this.display();
                } else {
                    fourier.this.ifftmod = 6;
                    fourier.this.display();
                }
            }
        });
        this.parameters.getContentPane().add(this.panel);
        this.parameters.pack();
        this.parameters.setVisible(false);
    }

    @Override
    public void go() {
        System.out.println(this.name);
        if (this.getInput1() != null && this.getInput2() != null) {
            System.out.println("Input Width 1 " + this.getInput1().getWidth());
            this.fourierOp = new FFT(this.input1.getValues(), this.input1.getWidth(), this.input1.getHeight());
            this.inverse = new InverseFFT();
            this.w = this.fourierOp.output.width;
            this.h = this.fourierOp.output.height;
            this.fres = new TwoDArray(this.w, this.h);
            this.ires = new TwoDArray(this.w, this.h);
            this.fouriers = new double[7][this.w * this.h];
            this.ifouriers = new double[7][this.w * this.h];
            this.fres = this.fourierOp.intermediate;
            this.ires = this.inverse.transform(this.fourierOp.intermediate);
            try {
                if (!operatorBox.links.getLink((operator)this, (JLabel)this.box.getIn2()).linkFrom.getType().equals("FFTMask")) {
                    JOptionPane.showMessageDialog(null, "You should use a mask", "Error!", 2);
                    return;
                }
                this.multiply();
            }
            catch (NullPointerException nullPointerException) {
                JOptionPane.showMessageDialog(null, "You should use a FFT Mask, not an image or output from an operator in FFTMask", "Error!", 2);
            }
            this.fouriers[0] = this.fres.DCToCentre(this.fres.getMagnitude());
            this.fouriers[1] = ImageMods.logs(this.fouriers[0]);
            this.fouriers[2] = ImageMods.abs(this.fres.DCToCentre(this.fres.getPhase()));
            this.fouriers[3] = ImageMods.abs(this.fres.DCToCentre(this.fres.getReal()));
            this.fouriers[4] = ImageMods.logs(this.fouriers[3]);
            this.fouriers[5] = ImageMods.abs(this.fres.DCToCentre(this.fres.getImaginary()));
            this.fouriers[6] = ImageMods.logs(this.fouriers[5]);
            this.ifouriers[0] = this.ires.getMagnitude();
            this.ifouriers[1] = ImageMods.logs(this.ifouriers[0]);
            this.ifouriers[2] = ImageMods.abs(this.ires.getPhase());
            this.ifouriers[3] = ImageMods.abs(this.ires.getReal());
            this.ifouriers[4] = ImageMods.logs(this.ifouriers[3]);
            this.ifouriers[5] = ImageMods.abs(this.ires.getImaginary());
            this.ifouriers[6] = ImageMods.logs(this.ifouriers[5]);
            this.output1 = new image1DInt(this.input1.getWidth(), this.input1.getHeight(), imageConversions.pix2gs(ImageMods.toPixels(this.fouriers[this.fftmod])));
            this.output2 = new image1DInt(this.input1.getWidth(), this.input1.getHeight(), imageConversions.pix2gs(ImageMods.toPixels(ImageMods.allPositive(this.ifouriers[this.ifftmod]))));
            System.out.println("Output width " + this.getOutput1().getWidth());
            this.propagate();
        }
    }

    public void display() {
        if (this.getInput1() != null) {
            this.output1 = new image1DInt(this.input1.getWidth(), this.input1.getHeight(), imageConversions.pix2gs(ImageMods.toPixels(this.fouriers[this.fftmod])));
            this.output2 = new image1DInt(this.input1.getWidth(), this.input1.getHeight(), imageConversions.pix2gs(ImageMods.toPixels(ImageMods.allPositive(this.ifouriers[this.ifftmod]))));
            this.propagate();
        }
    }

    public void multiply() {
        int n;
        int n2;
        System.out.println("width " + this.w + " height " + this.h + " length " + this.input2.getValues().length);
        TwoDArray twoDArray = new TwoDArray(this.input2.getValues(), this.w, this.h);
        TwoDArray twoDArray2 = new TwoDArray(this.fres);
        double[] dArray = new double[this.w * this.h];
        for (int i = 0; i < this.h; ++i) {
            for (n2 = 0; n2 < this.w; ++n2) {
                dArray[i * this.w + n2] = this.input2.getValues()[i * this.w + n2];
            }
        }
        dArray = twoDArray.DCToCentre(dArray);
        int[] nArray = new int[this.w * this.h];
        for (n2 = 0; n2 < this.h; ++n2) {
            for (n = 0; n < this.w; ++n) {
                nArray[n2 * this.w + n] = (int)dArray[n2 * this.w + n];
            }
        }
        twoDArray = new TwoDArray(nArray, this.w, this.h);
        for (n2 = 0; n2 < this.h; ++n2) {
            for (n = 0; n < this.w; ++n) {
                if (twoDArray.values[n][n2].real == 255.0) continue;
                ComplexNumber cfr_ignored_0 = twoDArray2.values[n][n2];
                twoDArray2.values[n][n2] = ComplexNumber.cMult(twoDArray2.values[n][n2], twoDArray.values[n][n2]);
            }
        }
        this.fres = twoDArray2;
        this.ires = this.inverse.transform(this.fres);
    }
}

