/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.StreamTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class histogram
extends operator1DInt {
    image1DInt temp;
    static int number = 0;
    String type = new String("IntensityHistogram");
    HistCanvas dest_canvas;
    JButton applyButton;
    JLabel maxLabel;
    JLabel peakLabel;
    JPanel bottompanel;
    JLabel rescaleLabel;
    JTextField rescaleText;
    JLabel spaceText;
    int histpeak;
    double histmaximum;
    int scaleMax;
    int val;
    JLabel hist_range = new JLabel("0           64             128           192          256");
    Histogram histogramAlgorithm = new Histogram();
    int[] hist_1d;
    Image hist;

    public histogram() {
    }

    public histogram(JPanel jPanel, linkData linkData2) {
        this.setName(this.type + "_" + ++number);
        this.setParameters();
        this.setType(this.type);
        this.setBox(jPanel, linkData2, 1, 1);
    }

    @Override
    public String saveParameters() {
        String string = new String();
        string = this.rescaleText.getText();
        return string;
    }

    @Override
    public void loadParameters(StreamTokenizer streamTokenizer) throws IOException {
        int n = streamTokenizer.nextToken();
        this.scaleMax = (int)streamTokenizer.nval;
        this.rescaleText.setText(String.valueOf(this.scaleMax));
        this.parameters.pack();
        this.parameters.setVisible(false);
    }

    void setParameters() {
        this.parameters = new JFrame(this.name);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.bottompanel = new JPanel();
        this.bottompanel.setLayout(new BorderLayout());
        this.panel.add((Component)this.bottompanel, "South");
        this.rescaleLabel = new JLabel("New maximum for histogram scaling:");
        this.rescaleText = new JTextField(5);
        this.rescaleText.setText("-1");
        this.spaceText = new JLabel("                ");
        this.panel.add((Component)this.spaceText, "West");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Apply scaling");
        jPanel.add(this.rescaleLabel);
        jPanel.add(this.rescaleText);
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                histogram.this.scale();
            }
        });
        this.panel.add((Component)jPanel, "North");
        this.parameters.getContentPane().add(this.panel);
        this.parameters.pack();
        this.parameters.setVisible(false);
    }

    @Override
    public void go() {
        System.out.println(this.name);
        if (this.getInput1() != null) {
            int[] nArray = imageConversions.gs2pix(this.input1.getValues());
            this.histpeak = this.histogramAlgorithm.peak(nArray, this.input1.getWidth(), this.input1.getHeight());
            this.histmaximum = this.histogramAlgorithm.maximum(nArray, this.input1.getWidth(), this.input1.getHeight());
            Double d = new Double(this.rescaleText.getText());
            if (d < 0.0) {
                this.scaleMax = (int)this.histmaximum;
                this.rescaleText.setText(String.valueOf(this.scaleMax));
            }
            int[] nArray2 = this.histogramAlgorithm.histogramScale(nArray, this.input1.getWidth(), this.input1.getHeight(), this.scaleMax);
            this.hist = this.parameters.createImage(new MemoryImageSource(256, 256, nArray2, 0, 256));
            this.updateDisplay();
            this.output1 = new image1DInt(this.input1.getWidth(), this.input1.getHeight(), this.input1.getValues());
            System.out.println("Output Width 1 " + this.getOutput1().getWidth());
            this.propagate();
        }
    }

    void updateDisplay() {
        if (this.dest_canvas != null) {
            this.panel.remove(this.dest_canvas);
        }
        this.dest_canvas = new HistCanvas(this.hist, 256, this.scaleMax);
        this.panel.add((Component)this.dest_canvas, "Center");
        if (this.peakLabel != null) {
            this.bottompanel.remove(this.peakLabel);
        }
        this.peakLabel = new JLabel("Peak position: " + this.histpeak);
        this.bottompanel.add((Component)this.peakLabel, "North");
        if (this.maxLabel != null) {
            this.bottompanel.remove(this.maxLabel);
        }
        this.maxLabel = new JLabel("Maximum value: " + (int)this.histmaximum);
        this.bottompanel.add((Component)this.maxLabel, "South");
        this.parameters.pack();
        this.updateParameters();
    }

    void scale() {
        try {
            this.scaleMax = (int)new Double(this.rescaleText.getText()).doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Wrong Format for scale", "Error!", 2);
            return;
        }
        if (this.scaleMax <= 0) {
            JOptionPane.showMessageDialog(null, "Scale value must be positive", "Error!", 2);
            return;
        }
        int[] nArray = this.histogramAlgorithm.histogramScale(imageConversions.gs2pix(this.input1.getValues()), this.input1.getWidth(), this.input1.getHeight(), this.scaleMax);
        this.hist = this.parameters.createImage(new MemoryImageSource(256, 256, nArray, 0, 256));
        if (this.dest_canvas != null) {
            this.panel.remove(this.dest_canvas);
        }
        this.dest_canvas = new HistCanvas(this.hist, 256, this.scaleMax);
        this.panel.add((Component)this.dest_canvas, "Center");
        this.parameters.pack();
        this.updateParameters();
    }

    public class HistCanvas
    extends NoScaleImageCanvas {
        int w;
        int h;

        public HistCanvas(Image image2, int n, int n2) {
            super(image2);
            this.w = n;
            this.h = n2;
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(Color.red);
            graphics.drawLine(0, 0, 0, 255);
            graphics.drawLine(0, 0, 10, 0);
            graphics.drawLine(0, 64, 5, 64);
            graphics.drawLine(0, 128, 10, 128);
            graphics.drawLine(0, 192, 5, 192);
            graphics.drawLine(0, 256, 10, 256);
            int n = 0;
            int n2 = this.h / 4;
            int n3 = n2 + n2;
            int n4 = n2 + n3;
            int n5 = this.h;
            graphics.drawString(Integer.toString(n5), 0, 15);
            graphics.drawString(Integer.toString(n3), 10, 140);
            graphics.drawString(Integer.toString(n), 5, 250);
            graphics.setColor(Color.red);
            graphics.drawLine(0, 255, 255, 255);
            graphics.drawLine(0, 255, 0, 245);
            graphics.drawLine(64, 255, 64, 250);
            graphics.drawLine(128, 255, 128, 245);
            graphics.drawLine(192, 255, 192, 250);
            graphics.drawLine(256, 255, 256, 245);
            int n6 = 0;
            int n7 = this.w / 4;
            int n8 = n7 + n7;
            int n9 = n7 + n8;
            int n10 = this.w;
            graphics.drawString(Integer.toString(n6), 5, 240);
            graphics.drawString(Integer.toString(n8), 123, 240);
            graphics.drawString(Integer.toString(n10), 230, 240);
        }
    }
}

