/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class imageDisplay
extends operator1DInt {
    JScrollPane scroll;
    JPanel bottomPanel;
    JPanel middlePanel;
    JLabel imageLabel;
    JLabel scaleLabel;
    JLabel offsetLabel;
    JLabel position = new JLabel("Point X:  Y: ");
    JLabel intensity = new JLabel("Intensity: ");
    PixelListener brpl = new PixelListener();
    JTextField scaleBox;
    JTextField offsetBox;
    JButton applyButton;
    JButton saveButton;
    File file;
    Image displayImage;
    ImageIcon imageIcon;
    int actualx;
    int actualy;
    NoScaleImageCanvas dest_canvas;
    int[] pixels;
    static int number = 0;
    String type = new String("ImageDisplay");

    public imageDisplay(JPanel jPanel, linkData linkData2) {
        this.setName(this.type + '_' + ++number);
        this.setParameters();
        this.setType(this.type);
        this.setBox(jPanel, linkData2, 1, 1);
    }

    public int getNumber() {
        return number;
    }

    @Override
    public void loadParameters(StreamTokenizer streamTokenizer) throws IOException {
        int n = streamTokenizer.nextToken();
        double d = streamTokenizer.nval;
        this.scaleBox.setText(new Double(d).toString());
        n = streamTokenizer.nextToken();
        double d2 = streamTokenizer.nval;
        this.offsetBox.setText(new Double(d2).toString());
    }

    @Override
    public String saveParameters() {
        String string = this.scaleBox.getText() + " " + this.offsetBox.getText();
        return string;
    }

    void setParameters() {
        this.parameters = new JFrame(this.name);
        this.panel = new JPanel();
        this.bottomPanel = new JPanel();
        this.middlePanel = new JPanel();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.scaleLabel = new JLabel("Scale ");
        this.offsetLabel = new JLabel("Offset ");
        this.scaleBox = new JTextField(5);
        this.scaleBox.setText("1.0");
        this.offsetBox = new JTextField(5);
        this.offsetBox.setText("0");
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                imageDisplay.this.updateDisplay();
            }
        });
        this.panel.setLayout(new BorderLayout());
        this.middlePanel.add(this.position);
        this.middlePanel.add(this.intensity);
        this.bottomPanel.add(this.scaleLabel);
        this.bottomPanel.add(this.scaleBox);
        this.bottomPanel.add(this.offsetLabel);
        this.bottomPanel.add(this.offsetBox);
        this.bottomPanel.add(this.applyButton);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.bottomPanel, "North");
        jPanel.add((Component)jPanel2, "South");
        this.panel.add((Component)this.middlePanel, "North");
        this.panel.add((Component)jPanel, "South");
        this.parameters.getContentPane().add(this.panel);
        this.parameters.pack();
        this.parameters.setVisible(false);
        this.parameters.setLocation(new Point(100, 100));
    }

    void updateDisplay() {
        try {
            this.pixels = (int[])this.input1.getValues().clone();
            try {
                float f = Float.valueOf(this.scaleBox.getText()).floatValue();
                float f2 = Float.valueOf(this.offsetBox.getText()).floatValue();
                for (int i = 0; i < this.pixels.length; ++i) {
                    int n = (int)((float)this.pixels[i] * f + f2);
                    if (n > 255) {
                        n = 255;
                    } else if (n < 0) {
                        n = 0;
                    }
                    this.pixels[i] = new Color(n, n, n).getRGB();
                }
                this.displayImage = this.parameters.createImage(new MemoryImageSource(this.input1.getWidth(), this.input1.getHeight(), this.pixels, 0, this.input1.getWidth()));
                if (this.dest_canvas != null) {
                    this.panel.remove(this.dest_canvas);
                }
                this.dest_canvas = new NoScaleImageCanvas(this.displayImage);
                this.dest_canvas.addMouseMotionListener(this.brpl);
                this.panel.add((Component)this.dest_canvas, "Center");
                this.updateParameters();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, "Invalid scale or offset", "Error!", 2);
                this.scaleBox.setText("1.0");
                this.offsetBox.setText("0");
            }
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(null, "Probably binary operator does not have 2 image", "Error!", 2);
            this.scaleBox.setText("1.0");
            this.offsetBox.setText("0");
        }
    }

    @Override
    public void go() {
        if (this.getInput1() != null) {
            System.out.println(this.name);
            System.out.println("Input width " + this.getInput1().getWidth());
            this.output1 = new image1DInt(this.getInput1());
            System.out.println("Output width " + this.getOutput1().getWidth());
            this.updateDisplay();
            this.propagate();
        }
    }

    public class PixelListener
    extends MouseMotionAdapter {
        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            NoScaleImageCanvas noScaleImageCanvas = (NoScaleImageCanvas)mouseEvent.getSource();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            boolean bl = false;
            boolean bl2 = false;
            int n3 = noScaleImageCanvas.getImageWidth();
            int n4 = noScaleImageCanvas.getImageHeight();
            try {
                imageDisplay.this.actualx = n;
                imageDisplay.this.actualy = n2;
                if (imageDisplay.this.actualx >= 0 && imageDisplay.this.actualy >= 0) {
                    if (imageDisplay.this.actualx > n3 - 1) {
                        imageDisplay.this.actualx = n3 - 1;
                    }
                    if (imageDisplay.this.actualy > n4 - 1) {
                        imageDisplay.this.actualy = n4 - 1;
                    }
                    if (noScaleImageCanvas == imageDisplay.this.dest_canvas) {
                        int n5 = imageDisplay.this.pixels[imageDisplay.this.actualx + imageDisplay.this.actualy * n3] & 0xFF;
                        imageDisplay.this.position.setText("Point X:" + imageDisplay.this.actualx + "  Y:" + imageDisplay.this.actualy);
                        imageDisplay.this.intensity.setText("Intensity:" + n5);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }
}

