/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StreamTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class lapOfGauss
extends operator1DInt {
    JLabel kernelLabel = new JLabel("Kernel Size");
    JTextField kernelText = new JTextField("7", 5);
    JLabel thetaLabel = new JLabel("Theta Value");
    JTextField thetaText = new JTextField("0.6", 5);
    JButton applyButton = new JButton("Apply");
    JLabel scaleLabel = new JLabel("Output Display Scale Value");
    JTextField scaleText = new JTextField("1.0", 5);
    JLabel offsetLabel = new JLabel("Output Display Offset Value");
    JTextField offsetText = new JTextField("0.0", 5);
    static int number = 0;
    String type = new String("LaplacianOfGaussian");
    int kernelsize;
    double theta;

    public lapOfGauss() {
    }

    public lapOfGauss(JPanel jPanel, linkData linkData2) {
        this.setName(this.type + "_" + ++number);
        this.setParameters();
        this.setType(this.type);
        this.setBox(jPanel, linkData2, 1, 1);
    }

    @Override
    public void loadParameters(StreamTokenizer streamTokenizer) throws IOException {
        int n = streamTokenizer.nextToken();
        this.kernelsize = (int)streamTokenizer.nval;
        this.kernelText.setText(String.valueOf(this.kernelsize));
        n = streamTokenizer.nextToken();
        this.theta = streamTokenizer.nval;
        this.thetaText.setText(String.valueOf(this.theta));
        n = streamTokenizer.nextToken();
        double d = streamTokenizer.nval;
        this.scaleText.setText(String.valueOf(d));
        n = streamTokenizer.nextToken();
        double d2 = streamTokenizer.nval;
        this.offsetText.setText(String.valueOf(d2));
        this.parameters.pack();
        this.parameters.setVisible(false);
    }

    @Override
    public String saveParameters() {
        String string = new String();
        string = this.kernelsize + " " + this.theta + " " + this.scaleText.getText() + " " + this.offsetText.getText();
        return string;
    }

    void setParameters() {
        this.parameters = new JFrame(this.name);
        this.panel = new JPanel();
        this.panel.add(this.kernelLabel);
        this.panel.add(this.kernelText);
        this.panel.add(this.thetaLabel);
        this.panel.add(this.thetaText);
        this.panel.add(this.scaleLabel);
        this.panel.add(this.scaleText);
        this.panel.add(this.offsetLabel);
        this.panel.add(this.offsetText);
        this.panel.add(this.applyButton);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                lapOfGauss.this.go();
            }
        });
        this.parameters.getContentPane().add(this.panel);
        this.parameters.pack();
        this.parameters.setVisible(false);
    }

    @Override
    public void go() {
        System.out.println(this.name);
        try {
            try {
                this.kernelsize = new Integer(this.kernelText.getText());
                this.theta = new Double(this.thetaText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, "Invalid Parameters Specified", "Error!", 2);
                return;
            }
            if (this.getInput1() != null) {
                Log log = new Log(this.kernelsize, this.theta);
                System.out.println("Input Width 1 " + this.getInput1().getWidth());
                if (!log.kernelValid(this.theta)) {
                    JOptionPane.showMessageDialog(null, "Theta and size cannot generate a valid kernel. 0.5 < Theta < 0.09*size must hold.", "Invalid kernel", 2);
                    return;
                }
                this.output1 = new image1DInt(this.input1.getWidth(), this.input1.getHeight(), imageConversions.pix2gs(log.log_image(imageConversions.gs2pix(this.input1.getValues()), this.input1.getWidth(), this.input1.getHeight(), new Double(this.scaleText.getText()), new Double(this.offsetText.getText()))));
                System.out.println("Output width " + this.getOutput1().getWidth());
                this.propagate();
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Invalid Parameters Specified", "Error!", 2);
            return;
        }
    }
}

