/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.StreamTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class mask
extends operator1DInt {
    static int number = 0;
    String type = new String("FFTMask");
    int[] input;
    TwoDArray result;
    int w;
    int h;
    Image displayImage;
    ImageIcon imageIcon;
    JLabel imageLabel = new JLabel();
    JScrollPane scroll;
    maskCanvas dest_canvas;
    JPanel maskpanel = null;
    JPanel imagePanel;
    JPanel filterPanel;
    JButton notch = new JButton("Add Notch Filter");
    JTextField widthText = new JTextField("5", 5);
    JTextField radiusText = new JTextField("15", 5);
    JLabel widthLabel = new JLabel("Width");
    JLabel radiusLabel = new JLabel("Radius");
    JButton frequency = new JButton("Add Frequency Filter");
    JTextField freqText = new JTextField("50", 5);
    JComboBox freqchoice = new JComboBox();
    JLabel freqLabel = new JLabel("Radius");
    JButton gauss = new JButton("Add Gaussian Smooth");
    JTextField gsizeText = new JTextField("30", 5);
    JTextField yText = new JTextField("0", 5);
    JTextField xText = new JTextField("0", 5);
    JLabel gsizeLabel = new JLabel("Size");
    JLabel yLabel = new JLabel("  Y ");
    JLabel xLabel = new JLabel("X ");
    JButton remove = new JButton("Remove Area");
    JButton keep = new JButton("Keep Area");
    JLabel y1Label = new JLabel("Y1");
    JLabel x1Label = new JLabel("X1");
    JLabel y2Label = new JLabel("Y2");
    JLabel x2Label = new JLabel("X2");
    JTextField y1Text = new JTextField("10", 5);
    JTextField x1Text = new JTextField("10", 5);
    JTextField y2Text = new JTextField("20", 5);
    JTextField x2Text = new JTextField("20", 5);
    JButton apply = new JButton("Apply");
    JButton reset = new JButton("Reset mask");
    MaskHistory maskhistory = new MaskHistory();

    public mask(JPanel jPanel, linkData linkData2) {
        this.setName(this.type + "_" + ++number);
        this.setType(this.type);
        this.setParameters();
        this.setBox(jPanel, linkData2, 1, 1);
        this.box.getOut1().setText("FFTMask");
        this.go();
    }

    public int getNumber() {
        return number;
    }

    @Override
    public void loadParameters(StreamTokenizer streamTokenizer) throws IOException {
        this.maskhistory.clearHistory();
        this.maskhistory.loadHistory(streamTokenizer);
    }

    @Override
    public String saveParameters() {
        String string = new String();
        string = this.maskhistory.saveHistory();
        return string;
    }

    void setParameters() {
        this.parameters = new JFrame(this.name);
        this.filterPanel = new JPanel();
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.filterPanel.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        jPanel.add(this.notch);
        jPanel.add(this.widthLabel);
        jPanel.add(this.widthText);
        jPanel.add(this.radiusLabel);
        jPanel.add(this.radiusText);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.filterPanel.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.frequency);
        this.freqchoice.addItem("High Pass Filter");
        this.freqchoice.addItem("Low Pass Filter");
        jPanel2.add(this.freqchoice);
        jPanel2.add(this.freqLabel);
        jPanel2.add(this.freqText);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.filterPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.gauss);
        jPanel3.add(this.gsizeLabel);
        jPanel3.add(this.gsizeText);
        jPanel3.add(this.xLabel);
        jPanel3.add(this.xText);
        jPanel3.add(this.yLabel);
        jPanel3.add(this.yText);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        this.filterPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.remove);
        jPanel4.add(this.keep);
        jPanel4.add(this.x1Label);
        jPanel4.add(this.x1Text);
        jPanel4.add(this.y1Label);
        jPanel4.add(this.y1Text);
        jPanel4.add(this.x2Label);
        jPanel4.add(this.x2Text);
        jPanel4.add(this.y2Label);
        jPanel4.add(this.y2Text);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        this.filterPanel.add(jPanel4);
        this.notch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mask.this.apply_notch();
            }
        });
        this.frequency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mask.this.apply_freq();
            }
        });
        this.gauss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mask.this.apply_gauss();
            }
        });
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mask.this.apply_remove();
            }
        });
        this.keep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mask.this.apply_keep();
            }
        });
        this.panel.add((Component)this.filterPanel, "North");
        this.maskpanel = new JPanel();
        this.maskpanel.setLayout(new BorderLayout());
        this.panel.add((Component)this.maskpanel, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.add(this.apply);
        jPanel5.add(this.reset);
        this.panel.add((Component)jPanel5, "South");
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mask.this.apply();
            }
        });
        this.reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mask.this.clear();
                mask.this.maskhistory.clearHistory();
            }
        });
        this.parameters.getContentPane().add(this.panel);
        this.parameters.pack();
        this.parameters.setVisible(false);
    }

    @Override
    public void go() {
        System.out.println(this.name);
        if (this.getInput1() != null) {
            this.h = this.input1.getHeight();
            this.w = this.input1.getWidth();
            this.input = new int[this.h * this.w];
            for (int i = 0; i < this.input.length; ++i) {
                this.input[i] = 255;
            }
            this.result = new TwoDArray(this.input, this.w, this.h);
            this.maskhistory.apply_history();
            this.input = imageConversions.pix2gs(ImageMods.toPixels(this.result.getReal()));
            this.updatedisplay();
            this.output1 = new image1DInt(this.w, this.h, this.input);
            this.propagate();
            System.out.println("Output width " + this.output1.getWidth());
        }
    }

    public void clear() {
        for (int i = 0; i < this.input.length; ++i) {
            this.input[i] = 255;
        }
        this.result = new TwoDArray(this.input, this.w, this.h);
        this.updatedisplay();
    }

    public void apply() {
        TwoDArray twoDArray = new TwoDArray(this.result);
        this.input = imageConversions.pix2gs(ImageMods.toPixels(twoDArray.DCToCentre(twoDArray.getReal())));
        this.output1 = new image1DInt(this.w, this.h, this.input);
        System.out.println("Output width " + this.output1.getWidth());
        this.propagate();
    }

    public void apply_notch() {
        int n;
        int n2;
        TwoDArray twoDArray = new TwoDArray(this.result);
        try {
            n2 = new Integer(this.widthText.getText());
            n = new Integer(this.radiusText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Wrong Format for Width or Radius", "Error!", 2);
            return;
        }
        if (n2 <= 0 || n <= 0) {
            JOptionPane.showMessageDialog(null, "Invalid value for Width or Radius", "Error!", 2);
            return;
        }
        this.result = NotchFilter.notch(twoDArray, n2, n);
        this.maskhistory.addtoMaskHistory(1, n2, n, 0.0, 0.0);
        this.updatedisplay();
    }

    public void apply_gauss() {
        double d;
        int n;
        int n2;
        try {
            n2 = new Integer(this.xText.getText());
            n = new Integer(this.yText.getText());
            d = new Double(this.gsizeText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Wrong Format for Width or Radius", "Error!", 2);
            return;
        }
        TwoDArray twoDArray = new TwoDArray(this.result);
        this.result = Gaussian.smooth(twoDArray, n2, n, d);
        this.maskhistory.addtoMaskHistory(4, n2, n, d, 0.0);
        this.updatedisplay();
    }

    public void apply_freq() {
        int n;
        try {
            n = new Integer(this.freqText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Wrong Format for Width or Radius", "Error!", 2);
            return;
        }
        TwoDArray twoDArray = new TwoDArray(this.result);
        if (this.freqchoice.getSelectedItem().equals("High Pass Filter")) {
            this.maskhistory.addtoMaskHistory(2, n, 0.0, 0.0, 0.0);
            this.result = FreqFilter.filter(twoDArray, false, n);
        } else {
            this.maskhistory.addtoMaskHistory(3, n, 0.0, 0.0, 0.0);
            this.result = FreqFilter.filter(twoDArray, true, n);
        }
        this.updatedisplay();
    }

    public void apply_remove() {
        int n;
        int n2;
        int n3;
        int n4;
        try {
            n4 = new Integer(this.x1Text.getText());
            n3 = new Integer(this.x2Text.getText());
            n2 = new Integer(this.y1Text.getText());
            n = new Integer(this.y2Text.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Wrong Format for coordinates", "Error!", 2);
            return;
        }
        if (n4 < -this.w / 2 || n2 < -this.h / 2 || n3 > this.w / 2 || n > this.h / 2) {
            JOptionPane.showMessageDialog(null, "Coordinates out of bounds", "Error!", 2);
            return;
        }
        if (n4 > n3 || n2 > n) {
            JOptionPane.showMessageDialog(null, "Coordinates need x1 <= x2, y1 <= y2", "Error!", 2);
            return;
        }
        this.actual_remove(n4, n3, n2, n);
        this.maskhistory.addtoMaskHistory(5, n4, n3, n2, n);
        this.updatedisplay();
    }

    public void actual_remove(int n, int n2, int n3, int n4) {
        TwoDArray twoDArray = new TwoDArray(this.result);
        for (int i = 0; i < this.h; ++i) {
            for (int j = 0; j < this.w; ++j) {
                boolean bl = false;
                boolean bl2 = false;
                if (j <= this.w / 2) {
                    if (n <= j && j <= n2) {
                        bl = true;
                    }
                } else if (n <= j - this.w && j - this.w <= n2) {
                    bl = true;
                }
                if (i <= this.h / 2) {
                    if (n3 <= i && i <= n4) {
                        bl2 = true;
                    }
                } else if (n3 <= i - this.h && i - this.h <= n4) {
                    bl2 = true;
                }
                if (!bl || !bl2) continue;
                twoDArray.values[j][i].real = 0.0;
                twoDArray.values[j][i].imaginary = 0.0;
            }
        }
        this.result = twoDArray;
    }

    public void apply_keep() {
        int n;
        int n2;
        int n3;
        int n4;
        try {
            n4 = new Integer(this.x1Text.getText());
            n3 = new Integer(this.x2Text.getText());
            n2 = new Integer(this.y1Text.getText());
            n = new Integer(this.y2Text.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Wrong Format for coordinates", "Error!", 2);
            return;
        }
        if (n4 < -this.w / 2 || n2 < -this.h / 2 || n3 > this.w / 2 || n > this.h / 2) {
            JOptionPane.showMessageDialog(null, "Coordinates out of bounds", "Error!", 2);
            return;
        }
        if (n4 > n3 || n2 > n) {
            JOptionPane.showMessageDialog(null, "Coordinates need x1 <= x2, y1 <= y2", "Error!", 2);
            return;
        }
        this.actual_keep(n4, n3, n2, n);
        this.maskhistory.addtoMaskHistory(6, n4, n3, n2, n);
        this.updatedisplay();
    }

    public void actual_keep(int n, int n2, int n3, int n4) {
        TwoDArray twoDArray = new TwoDArray(this.result);
        for (int i = 0; i < this.h; ++i) {
            for (int j = 0; j < this.w; ++j) {
                boolean bl = false;
                boolean bl2 = false;
                if (j <= this.w / 2) {
                    if (n <= j && j <= n2) {
                        bl = true;
                    }
                } else if (n <= j - this.w && j - this.w <= n2) {
                    bl = true;
                }
                if (i <= this.h / 2) {
                    if (n3 <= i && i <= n4) {
                        bl2 = true;
                    }
                } else if (n3 <= i - this.h && i - this.h <= n4) {
                    bl2 = true;
                }
                if (bl && bl2) continue;
                twoDArray.values[j][i].real = 0.0;
                twoDArray.values[j][i].imaginary = 0.0;
            }
        }
        this.result = twoDArray;
    }

    public void updatedisplay() {
        ImageTools imageTools = new ImageTools();
        TwoDArray twoDArray = new TwoDArray(this.result);
        this.input = ImageMods.toPixels(twoDArray.DCToCentre(twoDArray.getReal()));
        this.displayImage = this.parameters.createImage(new MemoryImageSource(this.input1.getWidth(), this.input1.getHeight(), this.input, 0, this.input1.getWidth()));
        if (this.dest_canvas != null) {
            this.maskpanel.remove(this.dest_canvas);
        }
        this.dest_canvas = new maskCanvas(this.displayImage, this.input1.getWidth(), this.input1.getHeight());
        JLabel jLabel = new JLabel("                                            ");
        this.maskpanel.add((Component)jLabel, "West");
        this.maskpanel.add(this.dest_canvas);
        this.updateParameters();
    }

    public class MaskHistory {
        int historylength = 0;
        MaskHistoryItem[] history = new MaskHistoryItem[50];

        public void clearHistory() {
            this.historylength = 0;
        }

        public void addtoMaskHistory(int n, double d, double d2, double d3, double d4) {
            this.history[this.historylength] = new MaskHistoryItem(n, d, d2, d3, d4);
            if (this.historylength >= 49) {
                JOptionPane.showMessageDialog(null, "Out of history logging space", "Error!", 2);
            } else {
                ++this.historylength;
            }
        }

        public String saveHistory() {
            String string = new String();
            string = " " + this.historylength;
            for (int i = 0; i < this.historylength; ++i) {
                string = string + this.history[i].saveMaskHistoryItem();
            }
            return string;
        }

        public void loadHistory(StreamTokenizer streamTokenizer) throws IOException {
            int n = streamTokenizer.nextToken();
            this.historylength = (int)streamTokenizer.nval;
            for (int i = 0; i < this.historylength; ++i) {
                this.history[i] = new MaskHistoryItem();
                this.history[i].loadMaskHistoryItem(streamTokenizer);
            }
        }

        public void apply_history() {
            for (int i = 0; i < this.historylength; ++i) {
                this.history[i].applyHistoryItem();
            }
        }
    }

    public class MaskHistoryItem {
        int type;
        double arg1;
        double arg2;
        double arg3;
        double arg4;

        public MaskHistoryItem() {
        }

        public MaskHistoryItem(int n, double d, double d2, double d3, double d4) {
            this.type = n;
            this.arg1 = d;
            this.arg2 = d2;
            this.arg3 = d3;
            this.arg4 = d4;
        }

        public String saveMaskHistoryItem() {
            String string = new String();
            string = " " + this.type + " " + " " + this.arg1 + " " + this.arg2 + " " + this.arg3 + " " + this.arg4 + " ";
            return string;
        }

        public void loadMaskHistoryItem(StreamTokenizer streamTokenizer) throws IOException {
            int n = streamTokenizer.nextToken();
            this.type = (int)streamTokenizer.nval;
            n = streamTokenizer.nextToken();
            this.arg1 = streamTokenizer.nval;
            n = streamTokenizer.nextToken();
            this.arg2 = streamTokenizer.nval;
            n = streamTokenizer.nextToken();
            this.arg3 = streamTokenizer.nval;
            n = streamTokenizer.nextToken();
            this.arg4 = streamTokenizer.nval;
        }

        public void applyHistoryItem() {
            switch (this.type) {
                case 1: {
                    TwoDArray twoDArray = new TwoDArray(mask.this.result);
                    mask.this.result = NotchFilter.notch(twoDArray, (int)this.arg1, (int)this.arg2);
                    break;
                }
                case 2: {
                    TwoDArray twoDArray = new TwoDArray(mask.this.result);
                    mask.this.result = FreqFilter.filter(twoDArray, false, (int)this.arg1);
                    break;
                }
                case 3: {
                    TwoDArray twoDArray = new TwoDArray(mask.this.result);
                    mask.this.result = FreqFilter.filter(twoDArray, true, (int)this.arg1);
                    break;
                }
                case 4: {
                    TwoDArray twoDArray = new TwoDArray(mask.this.result);
                    mask.this.result = Gaussian.smooth(twoDArray, (int)this.arg1, (int)this.arg2, this.arg3);
                    break;
                }
                case 5: {
                    mask.this.actual_remove((int)this.arg1, (int)this.arg2, (int)this.arg3, (int)this.arg4);
                    break;
                }
                case 6: {
                    mask.this.actual_keep((int)this.arg1, (int)this.arg2, (int)this.arg3, (int)this.arg4);
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(null, "History item type error: " + this.type, "Error!", 2);
                    return;
                }
            }
        }
    }

    public class maskCanvas
    extends NoScaleImageCanvas {
        int w;
        int h;

        public maskCanvas(Image image2, int n, int n2) {
            super(image2);
            this.w = n;
            this.h = n2;
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(Color.green);
            graphics.drawLine(0, 0, 255, 0);
            graphics.drawLine(0, 65, 255, 65);
            graphics.drawLine(0, 129, 256, 129);
            graphics.drawLine(0, 192, 256, 192);
            graphics.drawLine(0, 256, 256, 256);
            int n = -this.h + this.h / 2;
            int n2 = n + this.h / 4;
            int n3 = 0;
            int n4 = this.h + n + n2;
            int n5 = this.h + n - 1;
            graphics.drawString(Integer.toString(n), 5, 15);
            graphics.drawString(Integer.toString(n2), 5, 76);
            graphics.drawString(Integer.toString(n3), 5, 140);
            graphics.drawString(Integer.toString(n4), 5, 204);
            graphics.drawString(Integer.toString(n5), 5, 255);
            graphics.setColor(Color.red);
            graphics.drawLine(0, 0, 0, 256);
            graphics.drawLine(65, 0, 65, 256);
            graphics.drawLine(129, 0, 129, 256);
            graphics.drawLine(192, 0, 192, 256);
            graphics.drawLine(256, 0, 256, 256);
            int n6 = -this.w + this.w / 2;
            int n7 = n + this.w / 4;
            int n8 = 0;
            int n9 = this.w + n + n2;
            int n10 = this.w + n - 1;
            graphics.drawString(Integer.toString(n6), 5, 25);
            graphics.drawString(Integer.toString(n7), 66, 25);
            graphics.drawString(Integer.toString(n8), 130, 25);
            graphics.drawString(Integer.toString(n9), 194, 25);
            graphics.drawString(Integer.toString(n10), 230, 25);
        }
    }
}

