/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.StreamTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class threshold
extends operator1DInt {
    image1DInt temp;
    Threshold thresholdOp = new Threshold();
    static int number = 0;
    String type = new String("Thresholding");
    thresholdImageCanvas histImage;
    JLabel lowLabel;
    JTextField lowBox;
    JSlider lowSlider;
    JLabel highLabel;
    JTextField highBox;
    JSlider highSlider;
    JPanel histPanel;
    JPanel topPanel;
    JPanel midPanel;
    JPanel bottomPanel;
    JButton applyButton;
    JLabel maxLabel;
    JLabel peakLabel;
    GridBagLayout panelLayout;
    GridBagConstraints panelCon;
    int highT;
    int lowT;
    int histpeak;
    double histmaximum;
    int val;
    JLabel rescaleLabel;
    JTextField rescaleText;
    int scaleMax;
    JPanel rescalePanel;
    JLabel hist_range = new JLabel("0           64             128           192          256");
    Histogram histogramAlgorithm = new Histogram();
    int[] hist_1d;
    Image hist;

    public threshold() {
    }

    public threshold(JPanel jPanel, linkData linkData2) {
        this.setName(this.type + "_" + ++number);
        this.setParameters();
        this.setType(this.type);
        this.setBox(jPanel, linkData2, 1, 1);
        this.box.getOut1().setText("BINOUT1");
    }

    @Override
    public String saveParameters() {
        String string = new String();
        string = this.highT + " " + this.lowT + " " + this.rescaleText.getText();
        return string;
    }

    @Override
    public void loadParameters(StreamTokenizer streamTokenizer) throws IOException {
        int n = streamTokenizer.nextToken();
        int n2 = (int)streamTokenizer.nval;
        this.highSlider.setValue(n2);
        this.highBox.setText(String.valueOf(n2));
        this.highT = n2;
        n = streamTokenizer.nextToken();
        int n3 = (int)streamTokenizer.nval;
        this.lowSlider.setValue(n3);
        this.lowBox.setText(String.valueOf(n3));
        this.lowT = n3;
        n = streamTokenizer.nextToken();
        this.scaleMax = (int)streamTokenizer.nval;
        this.rescaleText.setText(String.valueOf(this.scaleMax));
        this.updateThreshold(this.lowSlider.getValue(), this.highSlider.getValue());
        this.parameters.pack();
        this.parameters.setVisible(false);
    }

    void setParameters() {
        this.highT = 192;
        this.lowT = 64;
        this.histImage = null;
        this.parameters = new JFrame(this.name);
        this.panel = new JPanel();
        this.panelLayout = new GridBagLayout();
        this.panelCon = new GridBagConstraints();
        this.histPanel = new JPanel();
        this.topPanel = new JPanel();
        this.midPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.lowLabel = new JLabel("Low Threshold");
        this.lowBox = new JTextField(5);
        this.lowBox.setText("64");
        this.lowBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.valueOf(threshold.this.lowBox.getText());
                    if (n >= 0 && n <= 255) {
                        threshold.this.lowSlider.setValue(n);
                    } else {
                        JOptionPane.showMessageDialog(null, "Threshold must lie between 0 and 255", "Error!", 2);
                        threshold.this.lowSlider.setValue(64);
                        threshold.this.lowBox.setText("64");
                    }
                    threshold.this.updateThreshold(threshold.this.lowSlider.getValue(), threshold.this.highSlider.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Invalid threshold specified", "Error!", 2);
                }
            }
        });
        this.lowSlider = new JSlider(0, 0, 255, 64);
        this.lowSlider.setMajorTickSpacing(50);
        this.lowSlider.setMinorTickSpacing(5);
        this.lowSlider.setPaintTicks(true);
        this.lowSlider.setPaintLabels(true);
        this.lowSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                threshold.this.lowBox.setText(String.valueOf(threshold.this.lowSlider.getValue()));
                threshold.this.updateThreshold(threshold.this.lowSlider.getValue(), threshold.this.highSlider.getValue());
            }
        });
        this.topPanel.add(this.lowLabel);
        this.topPanel.add(this.lowBox);
        this.topPanel.add(this.lowSlider);
        this.highLabel = new JLabel("High Threshold");
        this.highBox = new JTextField(5);
        this.highBox.setText("192");
        this.highBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    try {
                        threshold.this.val = Integer.valueOf(threshold.this.highBox.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(null, "Invalid threshold specified", "Error!", 2);
                    }
                    if (threshold.this.val >= 0 && threshold.this.val <= 255) {
                        threshold.this.highSlider.setValue(threshold.this.val);
                    } else {
                        JOptionPane.showMessageDialog(null, "Threshold must lie between 0 and 255", "Error!", 2);
                        threshold.this.highSlider.setValue(192);
                        threshold.this.highBox.setText("192");
                    }
                    threshold.this.updateThreshold(threshold.this.lowSlider.getValue(), threshold.this.highSlider.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Invalid threshold specified", "Error!", 2);
                }
            }
        });
        this.highSlider = new JSlider(0, 0, 255, 192);
        this.highSlider.setMajorTickSpacing(50);
        this.highSlider.setMinorTickSpacing(5);
        this.highSlider.setPaintTicks(true);
        this.highSlider.setPaintLabels(true);
        this.highSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                threshold.this.highBox.setText(String.valueOf(threshold.this.highSlider.getValue()));
                threshold.this.updateThreshold(threshold.this.lowSlider.getValue(), threshold.this.highSlider.getValue());
            }
        });
        this.midPanel.add(this.highLabel);
        this.midPanel.add(this.highBox);
        this.midPanel.add(this.highSlider);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                threshold.this.dothresh();
            }
        });
        this.bottomPanel.add(this.applyButton);
        this.panel.setLayout(this.panelLayout);
        this.panelCon.gridx = 0;
        this.panelCon.gridy = 0;
        this.panelLayout.setConstraints(this.topPanel, this.panelCon);
        this.panel.add(this.topPanel);
        this.panelCon.gridx = 0;
        this.panelCon.gridy = 1;
        this.panelLayout.setConstraints(this.midPanel, this.panelCon);
        this.panel.add(this.midPanel);
        this.panelCon.gridx = 0;
        this.panelCon.gridy = 2;
        this.panelLayout.setConstraints(this.bottomPanel, this.panelCon);
        this.panel.add(this.bottomPanel);
        this.rescaleLabel = new JLabel("New maximum for histogram scaling:");
        this.rescaleText = new JTextField(6);
        this.rescaleText.setText("-1");
        this.rescalePanel = new JPanel();
        this.rescalePanel.add(this.rescaleLabel);
        this.rescalePanel.add(this.rescaleText);
        JButton jButton = new JButton("Scale");
        this.rescalePanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                threshold.this.scale();
            }
        });
        this.parameters.getContentPane().add(this.panel);
        this.parameters.pack();
        this.parameters.setVisible(false);
    }

    public void updateThreshold(int n, int n2) {
        if (this.histImage != null) {
            if (n2 != this.highT) {
                this.histImage.highthresh = n2;
                this.highT = n2;
            }
            if (n != this.lowT) {
                this.histImage.lowthresh = n;
                this.lowT = n;
            }
            this.histImage.invalidate();
            this.histImage.repaint();
        }
    }

    @Override
    public void go() {
        System.out.println(this.name);
        if (this.getInput1() != null) {
            Double d = new Double(this.rescaleText.getText());
            if (d < 0.0) {
                int[] nArray = imageConversions.gs2pix(this.input1.getValues());
                this.scaleMax = (int)this.histogramAlgorithm.maximum(nArray, this.input1.getWidth(), this.input1.getHeight());
                this.rescaleText.setText(String.valueOf(this.scaleMax));
            }
            this.dothresh();
        }
    }

    public void dothresh() {
        System.out.println(this.name);
        if (this.getInput1() != null) {
            int[] nArray = imageConversions.gs2pix(this.input1.getValues());
            this.histpeak = this.histogramAlgorithm.peak(nArray, this.input1.getWidth(), this.input1.getHeight());
            this.histmaximum = this.histogramAlgorithm.maximum(nArray, this.input1.getWidth(), this.input1.getHeight());
            int[] nArray2 = this.histogramAlgorithm.histogramScale(nArray, this.input1.getWidth(), this.input1.getHeight(), this.scaleMax);
            this.hist = this.parameters.createImage(new MemoryImageSource(256, 256, nArray2, 0, 256));
            this.updateDisplay();
            if (this.highSlider.getValue() < this.lowSlider.getValue()) {
                JOptionPane.showMessageDialog(null, "High threshold must be bigger than low threshold", "Error!", 2);
            } else {
                this.output1 = new image1DInt(this.input1.getWidth(), this.input1.getHeight(), imageConversions.pix2gs(this.thresholdOp.twothreshold(imageConversions.gs2pix(this.input1.getValues()), this.input1.getWidth(), this.input1.getHeight(), this.lowT, this.highT)));
                this.propagate();
            }
        }
    }

    void updateDisplay() {
        this.histImage = new thresholdImageCanvas(this.hist, 256, this.scaleMax);
        this.histImage.lowthresh = this.lowT;
        this.histImage.highthresh = this.highT;
        this.panel.remove(this.histPanel);
        this.histPanel = new JPanel();
        this.histPanel.setLayout(new BorderLayout());
        this.histPanel.setBackground(Color.white);
        this.histPanel.add((Component)this.histImage, "Center");
        this.panelCon.gridx = 0;
        this.panelCon.gridy = 3;
        this.panelLayout.setConstraints(this.histPanel, this.panelCon);
        this.panel.add(this.histPanel);
        if (this.peakLabel != null) {
            this.panel.remove(this.peakLabel);
        }
        this.peakLabel = new JLabel("Peak Position: " + this.histpeak);
        this.panelCon.gridx = 0;
        this.panelCon.gridy = 4;
        this.panelLayout.setConstraints(this.peakLabel, this.panelCon);
        this.panel.add(this.peakLabel);
        if (this.maxLabel != null) {
            this.panel.remove(this.maxLabel);
        }
        this.maxLabel = new JLabel("Maximum value: " + (int)this.histmaximum);
        this.panelCon.gridx = 0;
        this.panelCon.gridy = 5;
        this.panelLayout.setConstraints(this.maxLabel, this.panelCon);
        this.panel.add(this.maxLabel);
        this.panelCon.gridx = 0;
        this.panelCon.gridy = 6;
        this.panelLayout.setConstraints(this.rescalePanel, this.panelCon);
        this.panel.add(this.rescalePanel);
        this.panel.repaint();
        this.parameters.pack();
        this.updateParameters();
    }

    void scale() {
        try {
            this.scaleMax = (int)new Double(this.rescaleText.getText()).doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Wrong Format for scale", "Error!", 2);
            return;
        }
        if (this.scaleMax <= 0) {
            JOptionPane.showMessageDialog(null, "Scale value must be positive", "Error!", 2);
            return;
        }
        int[] nArray = this.histogramAlgorithm.histogramScale(imageConversions.gs2pix(this.input1.getValues()), this.input1.getWidth(), this.input1.getHeight(), this.scaleMax);
        this.hist = this.parameters.createImage(new MemoryImageSource(256, 256, nArray, 0, 256));
        if (this.histImage != null) {
            this.histPanel.remove(this.histImage);
        }
        this.histImage = new thresholdImageCanvas(this.hist, 256, this.scaleMax);
        this.histImage.lowthresh = this.lowT;
        this.histImage.highthresh = this.highT;
        this.histPanel.add((Component)this.histImage, "Center");
        this.parameters.pack();
        this.updateParameters();
    }

    class thresholdImageCanvas
    extends NoScaleImageCanvas {
        public Image image;
        public int lowthresh;
        public int highthresh;
        private int oldlowthresh;
        private int oldhighthresh;
        int wvalue;
        int hvalue;

        public thresholdImageCanvas(Image image2, int n, int n2) {
            super(image2);
            this.lowthresh = 64;
            this.highthresh = 192;
            this.oldlowthresh = 64;
            this.oldhighthresh = 192;
            this.hvalue = n2;
            this.wvalue = n;
        }

        @Override
        public void paint(Graphics graphics) {
            this.setBackground(Color.gray);
            super.paint(graphics);
            graphics.setColor(Color.red);
            graphics.drawLine(this.highthresh, 1, this.highthresh, 256);
            graphics.setColor(Color.green);
            graphics.drawLine(this.lowthresh, 1, this.lowthresh, 256);
            graphics.setColor(Color.white);
            graphics.setColor(Color.red);
            graphics.drawLine(0, 0, 0, 255);
            graphics.drawLine(0, 0, 10, 0);
            graphics.drawLine(0, 64, 5, 64);
            graphics.drawLine(0, 128, 10, 128);
            graphics.drawLine(0, 192, 5, 192);
            graphics.drawLine(0, 256, 10, 256);
            int n = 0;
            int n2 = this.hvalue / 4;
            int n3 = n2 + n2;
            int n4 = n2 + n3;
            int n5 = this.hvalue;
            graphics.drawString(Integer.toString(n5), 0, 15);
            graphics.drawString(Integer.toString(n3), 10, 140);
            graphics.drawString(Integer.toString(n), 5, 250);
            graphics.setColor(Color.red);
            graphics.drawLine(0, 255, 255, 255);
            graphics.drawLine(0, 255, 0, 245);
            graphics.drawLine(64, 255, 64, 250);
            graphics.drawLine(128, 255, 128, 245);
            graphics.drawLine(192, 255, 192, 250);
            graphics.drawLine(256, 255, 256, 245);
            int n6 = 0;
            int n7 = this.wvalue / 4;
            int n8 = n7 + n7;
            int n9 = n7 + n8;
            int n10 = this.wvalue;
            graphics.drawString(Integer.toString(n6), 5, 240);
            graphics.drawString(Integer.toString(n8), 123, 240);
            graphics.drawString(Integer.toString(n10), 230, 240);
        }

        @Override
        public void update(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.drawLine(this.oldhighthresh, 1, this.oldhighthresh, 256);
            graphics.drawLine(this.oldlowthresh, 1, this.oldlowthresh, 256);
            graphics.drawImage(this.image, 1, 1, 256, 256, this);
            graphics.setColor(Color.red);
            graphics.drawLine(this.highthresh, 1, this.highthresh, 256);
            graphics.setColor(Color.green);
            graphics.drawLine(this.lowthresh, 1, this.lowthresh, 256);
            graphics.setColor(Color.white);
            this.oldlowthresh = this.lowthresh;
            this.oldhighthresh = this.highthresh;
        }
    }
}

